% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vec.R
\name{vec_fmt_spelled_num}
\alias{vec_fmt_spelled_num}
\title{Format a vector as spelled-out numbers}
\usage{
vec_fmt_spelled_num(
  x,
  pattern = "{x}",
  locale = NULL,
  output = c("auto", "plain", "html", "latex", "rtf", "word")
)
}
\arguments{
\item{x}{A numeric vector.}

\item{pattern}{A formatting pattern that allows for decoration of the
formatted value. The value itself is represented by \code{{x}} and all other
characters are taken to be string literals.}

\item{locale}{An optional locale identifier that can be used for formatting
the value according the locale's rules. Examples include \code{"en"} for English
(United States) and \code{"fr"} for French (France). The use of a locale ID will
override any locale-specific values provided. We can use the
\code{\link[=info_locales]{info_locales()}} function as a useful reference for all of the locales that
are supported.}

\item{output}{The output style of the resulting character vector. This can
either be \code{"auto"} (the default), \code{"plain"}, \code{"html"}, \code{"latex"}, \code{"rtf"},
or \code{"word"}. In \strong{knitr} rendering (i.e., Quarto or R Markdown), the
\code{"auto"} option will choose the correct \code{output} value}
}
\value{
A character vector.
}
\description{
With numeric values in a vector, we can transform those to numbers that are
spelled out. Any values from \code{0} to \code{100} can be spelled out according to the
specified locale. For example, the value \code{23} will be rendered as
\code{"twenty-three"} if the locale is an English-language one (or, not provided
at all); should a Swedish locale be provided (e.g., \code{"sv"}), the output will
instead be \code{"tjugotre"}.
}
\section{Examples}{


Let's create a numeric vector for the next few examples:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{num_vals <- c(1, 8, 23, 76, 0, -5, 200, NA)
}\if{html}{\out{</div>}}

Using \code{vec_fmt_spelled_num()} will create a character vector with values
rendered as spelled-out numbers. Any \code{NA} values remain as \code{NA} values. The
rendering context will be autodetected unless specified in the \code{output}
argument (here, it is of the \code{"plain"} output type).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_spelled_num(num_vals)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "one"     "eight"     "twenty-three"  "seventy-six"  "zero"
#> [6] "-5"      "200"       "NA"
}\if{html}{\out{</div>}}

If we are formatting for a different locale, we could supply the locale ID
and let \strong{gt} obtain a locale-specific set of spelled numbers:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_spelled_num(num_vals, locale = "af")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "een"     "agt"     "drie-en-twintig"     "ses-en-sewentig"
#> [5] "nul"     "-5"      "200"                 "NA"
}\if{html}{\out{</div>}}

As a last example, one can wrap the values in a pattern with the \code{pattern}
argument. Note here that \code{NA} values won't have the pattern applied.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{vec_fmt_spelled_num(num_vals, pattern = "\{x\}.")
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] "one."     "eight."     "twenty-three."  "seventy-six."  "zero."
#> [6] "-5."      "200."       "NA"
}\if{html}{\out{</div>}}
}

\section{Function ID}{

15-11
}

\section{Function Introduced}{

\emph{In Development}
}

\seealso{
The variant function intended for formatting \strong{gt} table data:
\code{\link[=fmt_spelled_num]{fmt_spelled_num()}}.

Other vector formatting functions: 
\code{\link{vec_fmt_bytes}()},
\code{\link{vec_fmt_currency}()},
\code{\link{vec_fmt_datetime}()},
\code{\link{vec_fmt_date}()},
\code{\link{vec_fmt_duration}()},
\code{\link{vec_fmt_engineering}()},
\code{\link{vec_fmt_fraction}()},
\code{\link{vec_fmt_index}()},
\code{\link{vec_fmt_integer}()},
\code{\link{vec_fmt_markdown}()},
\code{\link{vec_fmt_number}()},
\code{\link{vec_fmt_partsper}()},
\code{\link{vec_fmt_percent}()},
\code{\link{vec_fmt_roman}()},
\code{\link{vec_fmt_scientific}()},
\code{\link{vec_fmt_time}()}
}
\concept{vector formatting functions}
