% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{google_font}
\alias{google_font}
\title{Helper function for specifying a font from the \emph{Google Fonts} service}
\usage{
google_font(name)
}
\arguments{
\item{name}{The complete name of a font available in \emph{Google Fonts}.}
}
\value{
An object of class \code{font_css}.
}
\description{
The \code{google_font()} helper function can be used wherever a font name should
be specified. There are two instances where this helper can be used: the
\code{name} argument in \code{\link[=opt_table_font]{opt_table_font()}} (for setting a table font) and in that
of \code{\link[=cell_text]{cell_text()}} (used with \code{\link[=tab_style]{tab_style()}}). To get a helpful listing of fonts
that work well in tables, use the \code{\link[=info_google_fonts]{info_google_fonts()}} function.
}
\section{Examples}{


Use \code{\link{exibble}} to create a \strong{gt} table of eight rows, replace missing values
with em dashes. For text in the \code{time} column, we use the Google font
\code{"IBM Plex Mono"} and set up the \code{\link[=default_fonts]{default_fonts()}} as fallbacks (just in case
the webfont is not accessible).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble |>
  dplyr::select(char, time) |>
  gt() |>
  sub_missing() |>
  tab_style(
    style = cell_text(
      font = c(
        google_font(name = "IBM Plex Mono"),
        default_fonts()
      )
    ),
    locations = cells_body(columns = time)
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_google_font_1.png" alt="This image of a table was generated from the first code example in the `google_font()` help file." style="width:100\%;">
}}

Use \code{\link{sp500}} to create a small \strong{gt} table, using \code{\link[=fmt_currency]{fmt_currency()}} to
provide a dollar sign for the first row of monetary values. Then, set a
larger font size for the table and use the \code{"Merriweather"} font using the
\code{google_font()} function (with two font fallbacks: \code{"Cochin"} and the
catchall \code{"Serif"} group).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{sp500 |>
  dplyr::slice(1:10) |>
  dplyr::select(-volume, -adj_close) |>
  gt() |>
  fmt_currency(
    columns = 2:5,
    rows = 1,
    currency = "USD",
    use_seps = FALSE
  ) |>
  tab_options(table.font.size = px(20)) |>
  opt_table_font(
    font = list(
      google_font(name = "Merriweather"),
      "Cochin", "Serif"
    )
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_google_font_2.png" alt="This image of a table was generated from the second code example in the `google_font()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

8-27
}

\section{Function Introduced}{

\code{v0.2.2} (August 5, 2020)
}

\seealso{
Other helper functions: 
\code{\link{adjust_luminance}()},
\code{\link{cell_borders}()},
\code{\link{cell_fill}()},
\code{\link{cell_text}()},
\code{\link{cells_body}()},
\code{\link{cells_column_labels}()},
\code{\link{cells_column_spanners}()},
\code{\link{cells_footnotes}()},
\code{\link{cells_grand_summary}()},
\code{\link{cells_row_groups}()},
\code{\link{cells_source_notes}()},
\code{\link{cells_stub_grand_summary}()},
\code{\link{cells_stub_summary}()},
\code{\link{cells_stubhead}()},
\code{\link{cells_stub}()},
\code{\link{cells_summary}()},
\code{\link{cells_title}()},
\code{\link{currency}()},
\code{\link{default_fonts}()},
\code{\link{escape_latex}()},
\code{\link{gt_latex_dependencies}()},
\code{\link{html}()},
\code{\link{md}()},
\code{\link{pct}()},
\code{\link{px}()},
\code{\link{random_id}()},
\code{\link{stub}()},
\code{\link{system_fonts}()}
}
\concept{helper functions}
