% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{gibraltar}
\alias{gibraltar}
\title{Weather conditions in Gibraltar, May 2023}
\format{
A tibble with 1,431 rows and 10 variables:
\describe{
\item{date, time}{The date and time of the observation.}
\item{temp, dew_point}{The air temperature and dew point values, both in
degrees Celsius.}
\item{humidity}{The relative humidity as a value between \code{0} and \code{1}}
\item{wind_dir, wind_speed, wind_gust}{Observations related to wind. The wind
direction is given as the typical 'blowing from' value, simplified to one of
16 compass directions. The wind speed is provided in units of meters per
second. If there was a measurable wind gust, the maximum gust speed is
recorded as m/s values (otherwise the value is \code{0}).}
\item{pressure}{The atmospheric pressure in hectopascals (hPa).}
\item{condition}{The weather condition.}
}
}
\usage{
gibraltar
}
\description{
The \code{gibraltar} dataset has meteorological data for the Gibraltar Airport
Station from May 1 to May 31, 2023. Gibraltar is a British Overseas Territory
and city located at the southern end of the Iberian Peninsula, on the Bay of
Gibraltar. This weather station is located at the airport (GIB), where it's
at an elevation of 5 meters above mean sea level (AMSL).
}
\section{Examples}{


Here is a glimpse at the data available in \code{gibraltar}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::glimpse(gibraltar)
#> Rows: 1,431
#> Columns: 10
#> $ date       <date> 2023-05-01, 2023-05-01, 2023-05-01, 2023-05-01, 2023-05-01~
#> $ time       <chr> "00:20", "00:50", "01:20", "01:50", "02:20", "02:50", "03:2~
#> $ temp       <dbl> 18.9, 18.9, 17.8, 18.9, 18.9, 17.8, 17.8, 17.8, 18.9, 18.9,~
#> $ dew_point  <dbl> 12.8, 13.9, 13.9, 13.9, 12.8, 12.8, 12.8, 12.8, 12.2, 12.2,~
#> $ humidity   <dbl> 0.68, 0.73, 0.77, 0.73, 0.68, 0.73, 0.73, 0.73, 0.64, 0.64,~
#> $ wind_dir   <chr> "W", "WSW", "W", "W", "WSW", "WSW", "W", "SW", "SW", "WSW",~
#> $ wind_speed <dbl> 6.7, 7.2, 6.7, 6.7, 6.7, 6.7, 7.2, 6.3, 4.0, 3.1, 3.6, 2.2,~
#> $ wind_gust  <dbl> 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,~
#> $ pressure   <dbl> 1015.2, 1015.2, 1014.6, 1014.6, 1014.6, 1014.6, 1014.6, 101~
#> $ condition  <chr> "Fair", "Fair", "Fair", "Fair", "Fair", "Fair", "Fair", "Fa~
}\if{html}{\out{</div>}}
}

\section{Dataset ID and Badge}{

DATA-11

\if{html}{\out{
<div style="text-align:center;"><img src="https://raw.githubusercontent.com/rstudio/gt/master/images/dataset_gibraltar.png" alt="This image of that of a dataset badge." style="width:50\%;padding-bottom:20px;"></div>
}}
}

\section{Dataset Introduced}{

\code{v0.11.0}
}

\seealso{
Other datasets: 
\code{\link{constants}},
\code{\link{countrypops}},
\code{\link{exibble}},
\code{\link{films}},
\code{\link{gtcars}},
\code{\link{illness}},
\code{\link{metro}},
\code{\link{nuclides}},
\code{\link{peeps}},
\code{\link{photolysis}},
\code{\link{pizzaplace}},
\code{\link{reactions}},
\code{\link{rx_addv}},
\code{\link{rx_adsl}},
\code{\link{sp500}},
\code{\link{sza}},
\code{\link{towny}}
}
\concept{datasets}
\keyword{datasets}
