---
name: Bug
about: Something is wrong with gt.
title: ''
labels: 'Type: ☹︎ Bug'
assignees: rich-iannone
---

## Prework

* [ ] Read and agree to the [code of conduct](https://www.contributor-covenant.org/version/2/1/code_of_conduct.html) and [contributing guidelines](https://github.com/rstudio/gt/blob/master/.github/CONTRIBUTING.md).
* [ ] If there is [already a relevant issue](https://github.com/rstudio/gt/issues), whether open or closed, comment on the existing thread instead of posting a new issue.

## Description

Describe the bug clearly and concisely. 

## Reproducible example

* [ ] Post a [minimal reproducible example](https://www.tidyverse.org/help/) so the maintainer can troubleshoot the problems you identify. A reproducible example is:
    * [ ] **Runnable**: post enough R code and data so any onlooker can create the error on their own computer.
    * [ ] **Minimal**: reduce runtime wherever possible and remove complicated details that are irrelevant to the issue at hand.
    * [ ] **Readable**: format your code according to the [tidyverse style guide](https://style.tidyverse.org/).

## Expected result

What should have happened? Please be as specific as possible.

## Session info

End the reproducible example with a call to `sessionInfo()` in the same session (e.g. `reprex(session_info = TRUE)`) and include the output.
