% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{local_image}
\alias{local_image}
\title{Helper function for adding a local image}
\usage{
local_image(filename, height = 30)
}
\arguments{
\item{filename}{\emph{Path to image file}

\verb{scalar<character>} // \strong{required}

A local path to an image file on disk.}

\item{height}{\emph{Height of image}

\verb{scalar<numeric|integer>} // \emph{default:} \code{30}

The absolute height of the image in the table cell (in \code{"px"} units). By
default, this is set to \code{"30px"}.}
}
\value{
A character object with an HTML fragment that can be placed inside of
a cell.
}
\description{
We can flexibly add a local image (i.e., an image residing on disk) inside of
a table with \code{local_image()} function. The function provides a convenient way
to generate an HTML fragment using an on-disk PNG or SVG. Because this
function is currently HTML-based, it is only useful for HTML table output. To
use this function inside of data cells, it is recommended that the
\code{\link[=text_transform]{text_transform()}} function is used. With that function, we can specify which
data cells to target and then include a \code{local_image()} call within the
required user-defined function (for the \code{fn} argument). If we want to include
an image in other places (e.g., in the header, within footnote text, etc.) we
need to use \code{local_image()} within the \code{\link[=html]{html()}} helper function.

By itself, the function creates an HTML image tag with an image URI embedded
within. We can easily experiment with a local PNG or SVG image that's
available in the \strong{gt} package using the \code{\link[=test_image]{test_image()}} function. Using
that, the call \code{local_image(file = test_image(type = "png"))} evaluates to:

\verb{<img src=<data URI> style=\\"height:30px;\\">}

where a height of \verb{30px} is a default height chosen to work well within the
heights of most table rows.
}
\section{Examples}{


Create a tibble that contains heights of an image in pixels (one column as a
string, the other as numerical values), then, create a \strong{gt} table. Use the
\code{\link[=text_transform]{text_transform()}} function to insert a local test image (PNG) image with the
various sizes.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{dplyr::tibble(
  pixels = px(seq(10, 35, 5)),
  image = seq(10, 35, 5)
) |>
  gt() |>
  text_transform(
    locations = cells_body(columns = image),
    fn = function(x) \{
      local_image(
        filename = test_image(type = "png"),
        height = as.numeric(x)
      )
    \}
  )
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_local_image_1.png" alt="This image of a table was generated from the first code example in the `local_image()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

9-2
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other image addition functions: 
\code{\link{ggplot_image}()},
\code{\link{test_image}()},
\code{\link{web_image}()}
}
\concept{image addition functions}
