% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gaussian.R
\name{gaussian}
\alias{gaussian}
\title{Gaussian convolution window}
\usage{
gaussian(n, a = 1)
}
\arguments{
\item{n}{Window length, specified as a positive integer.}

\item{a}{Width factor, specified as a positive real scalar. \code{a} is
inversely proportional to the width of the window. Default: 1.}
}
\value{
Gaussian convolution window, returned as a vector.
}
\description{
Return a Gaussian convolution window of length \code{n}.
}
\details{
The width of the window is inversely proportional to the parameter \code{a}.
Use larger \code{a} for a narrower window. Use larger \code{m} for longer
tails.
\deqn{w = e^{(-(a*x)^{2}/2 )}}
for \code{x <- seq(-(n - 1) / 2, (n - 1) / 2, by = n)}.

Width a is measured in frequency units (sample rate/num samples). It should
be f when multiplying in the time domain, but 1/f when multiplying in the
frequency domain (for use in convolutions).
}
\examples{

g1 <- gaussian(128, 1)
g2 <- gaussian(128, 0.5)
plot (g1, type = "l", xlab = "Samples", ylab =" Amplitude", ylim = c(0, 1))
lines(g2, col = "red")

}
\author{
Paul Kienzle, \email{pkienzle@users.sf.net}.\cr
Conversion to R by Geert van Boxtel \email{G.J.M.vanBoxtel@gmail.com}.
}
