% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FilterSpecs.R
\name{FilterSpecs}
\alias{FilterSpecs}
\title{Filter specifications}
\usage{
FilterSpecs(n, Wc, type, ...)
}
\arguments{
\item{n}{filter order.}

\item{Wc}{cutoff frequency.}

\item{type}{filter type, normally one of \code{"low"}, \code{"high"},
\code{"stop"}, or \code{"pass"}.}

\item{...}{other filter description characteristics, possibly including Rp
for dB of pass band ripple or Rs for dB of stop band ripple, depending on
filter type (Butterworth, Chebyshev, etc.).}
}
\value{
A list of class \code{'FilterSpecs'} with the following list elements
  (repeats of the input arguments):
\describe{
  \item{n}{filter order}
  \item{Wc}{cutoff frequency}
  \item{type}{filter type, normally one of \code{"low"}, \code{"high"},
  \code{"stop"}, or \code{"pass"}.}
  \item{...}{other filter description characteristics, possibly including Rp
  for dB of pass band ripple or Rs for dB of stop band ripple, depending on
  filter type (Butterworth, Chebyshev, etc.).}
}
}
\description{
Filter specifications, including order, frequency cutoff, type, and
possibly others.
}
\examples{
filt <- FilterSpecs(3, 0.1, "low")

}
\seealso{
\code{\link{filter}}, \code{\link{butter}} and
  \code{\link{buttord}}, \code{\link{cheby1}} and \code{\link{cheb1ord}},
  \code{\link{ellip}} and \code{\link{ellipord}}.
}
\author{
Tom Short, \email{tshort@eprisolutions.com},\cr
 renamed and adapted by Geert van Boxtel, \email{gjmvanboxtel@gmail.com}
}
