% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tripulse.R
\name{tripuls}
\alias{tripuls}
\title{Sampled aperiodic triangle}
\usage{
tripuls(t, w = 1, skew = 0)
}
\arguments{
\item{t}{Sample times of triangle wave specified by a vector.}

\item{w}{Width of the triangular pulse to be generated. Default: 1.}

\item{skew}{Skew, a value between -1 and 1, indicating the relative placement
of the peak within the width. -1 indicates that the peak should be at
\code{-w / 2}, and 1 indicates that the peak should be at \code{w / 2}.
Default: 0 (no skew).}
}
\value{
Triangular pulse, returned as a vector.
}
\description{
Generate a triangular pulse over the interval \code{-w / 2} to \code{w / 2},
sampled at times \code{t}.
}
\details{
\code{y <- tripuls(t)} returns a continuous, aperiodic, symmetric,
unity-height triangular pulse at the times indicated in array \code{t},
centered about \code{t = 0} and with a default width of 1.

\code{y <- tripuls(t, w)} generates a triangular pulse of width \code{w}.

\code{y <- tripuls(t, w, skew)} generates a triangular pulse with skew
\code{skew}, where \eqn{-1 \le skew \le 1}. When \code{skew} is 0, a
symmetric triangular pulse is generated.
}
\examples{

fs <- 10e3
t <- seq(-0.1, 0.1, 1/fs)
w <- 40e-3
y <- tripuls(t, w)
plot(t, y, type="l", xlab = "", ylab = "",
     main = "Symmetric triangular pulse")

## displace into paste and future
tpast <- -45e-3
spast <- -0.45
ypast <- tripuls(t-tpast, w, spast)
tfutr <- 60e-3
sfutr <- 1
yfutr <- tripuls(t-tfutr, w/2, sfutr)
plot (t, y, type = "l", xlab = "", ylab = "", ylim = c(0, 1))
lines(t, ypast, col = "red")
lines(t, yfutr, col = "blue")

}
\author{
Paul Kienzle, Mike Miller.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
