% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stft.R
\name{stft}
\alias{stft}
\title{Short-Term Fourier Transform}
\usage{
stft(
  x,
  window = nextpow2(sqrt(NROW(x))),
  overlap = 0.75,
  nfft = ifelse(isScalar(window), window, length(window)),
  fs = 1
)
}
\arguments{
\item{x}{input data, specified as a numeric or complex vector or matrix. In
case of a vector it represents a single signal; in case of a matrix each
column is a signal.}

\item{window}{If \code{window} is a vector, each segment has the same length
as \code{window} and is multiplied by \code{window} before (optional)
zero-padding and calculation of its periodogram. If \code{window} is a
scalar, each segment has a length of \code{window} and a Hamming window is
used. Default: \code{nextpow2(sqrt(length(x)))} (the square root of the
length of \code{x} rounded up to the next power of two). The window length
must be larger than 3.}

\item{overlap}{segment overlap, specified as a numeric value expressed as a
multiple of window or segment length. 0 <= overlap < 1. Default: 0.5.}

\item{nfft}{Length of FFT, specified as an integer scalar. The default is the
length of the \code{window} vector or has the same value as the scalar
\code{window} argument.  If \code{nfft} is larger than the segment length,
(seg_len), the data segment is padded \code{nfft - seg_len} zeros. The
default is no padding. Nfft values smaller than the length of the data
segment (or window) are ignored. Note that the use of padding to increase
the frequency resolution of the spectral estimate is controversial.}

\item{fs}{sampling frequency (Hertz), specified as a positive scalar.
Default: 1.}
}
\value{
A list containing the following elements:
  \describe{
    \item{\code{f}}{vector of frequencies at which the STFT is estimated.
    If \code{x} is numeric, power from negative frequencies is added to the
    positive side of the spectrum, but not at zero or Nyquist (fs/2)
    frequencies. This keeps power equal in time and spectral domains. If
    \code{x} is complex, then the whole frequency range is returned.}
    \item{\code{t}}{vector of time points at which the STFT is estimated.}
    \item{\code{s}}{Short-time Fourier transform, returned as a matrix or
    a 3-D array. Time increases across the columns of \code{s} and frequency
    increases down the rows. The third dimension, if present, corresponds to
    the input channels.}
  }
}
\description{
Compute the short-term Fourier transform of a vector or matrix.
}
\examples{
fs <- 8000
y <- chirp(seq(0, 5 - 1/fs, by = 1/fs), 200, 2, 500, "logarithmic")
ft <- stft (y, fs = fs)
filled.contour(ft$t, ft$f, t(ft$s), xlab = "Time (s)",
               ylab = "Frequency (Hz)")

}
\author{
Andreas Weingessel, \email{Andreas.Weingessel@ci.tuwien.ac.at}.\cr
Conversion to R by Geert van Boxtel, \email{G.J.M.vanBoxtel@gmail.com}.
}
