% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_rtf.R
\name{as_rtf}
\alias{as_rtf}
\alias{as_rtf.gsBinomialExactTable}
\alias{as_rtf.gsBoundSummary}
\title{Save a summary table object as an RTF file}
\usage{
as_rtf(x, ...)

\method{as_rtf}{gsBinomialExactTable}(
  x,
  file,
  ...,
  title = paste("Operating Characteristics by Underlying Response Rate for",
    "Exact Binomial Group Sequential Design"),
  theta_label = "Underlying Response Rate",
  response_outcome = TRUE,
  bound_label = if (response_outcome) c("Futility Bound", "Efficacy Bound") else
    c("Efficacy Bound", "Futility Bound"),
  en_label = "Expected Sample Sizes",
  prob_decimals = 2,
  en_decimals = 1,
  rr_decimals = 0
)

\method{as_rtf}{gsBoundSummary}(
  x,
  file,
  ...,
  title = "Boundary Characteristics for Group Sequential Design",
  footnote_p_onesided = "one-side p-value for experimental better than control",
  footnote_appx_effect_at_bound = NULL,
  footnote_p_cross_h0 = "Cumulative type I error assuming binding futility bound",
  footnote_p_cross_h1 = "Cumulative power under the alternate hypothesis",
  footnote_specify = NULL,
  footnote_text = NULL
)
}
\arguments{
\item{x}{Object to be saved as RTF file.}

\item{...}{Other parameters that may be specific to the object.}

\item{file}{File path for the output.}

\item{title}{Title of the report.}

\item{theta_label}{Label for theta.}

\item{response_outcome}{Logical values indicating if the outcome is
response rate (\code{TRUE}) or failure rate (\code{FALSE}).
The default value is \code{TRUE}.}

\item{bound_label}{Label for bounds.
If the outcome is response rate, then the label is "Futility bound"
and "Efficacy bound".
If the outcome is failure rate, then the label is "Efficacy bound"
and "Futility bound".}

\item{en_label}{Label for expected number.}

\item{prob_decimals}{Number of decimal places for probability of crossing.}

\item{en_decimals}{Number of decimal places for expected number of
observations when bound is crossed or when trial ends without crossing.}

\item{rr_decimals}{Number of decimal places for response rates.}

\item{footnote_p_onesided}{Footnote for one-side p-value.}

\item{footnote_appx_effect_at_bound}{Footnote for approximate effect treatment at bound.}

\item{footnote_p_cross_h0}{Footnote for cumulative type I error.}

\item{footnote_p_cross_h1}{Footnote for cumulative power under the alternate hypothesis.}

\item{footnote_specify}{Vector of string to put footnote super script.}

\item{footnote_text}{Vector of string of footnote text.}
}
\value{
\code{as_rtf()} returns the input \code{x} invisibly.
}
\description{
Convert and save the summary table object created with \code{\link{as_table}}
to an RTF file using r2rtf; currently only implemented for
\code{\link{gsBinomialExact}}.
}
\details{
Currently only implemented for \code{\link{gsBinomialExact}} objects.
Creates a table to summarize an object.
For \code{\link{gsBinomialExact}}, this summarized operating characteristics
across a range of effect sizes.
}
\examples{
# as_rtf for gsBinomialExact
zz <- gsBinomialExact(
  k = 3, theta = seq(0.1, 0.9, 0.1), n.I = c(12, 24, 36),
  a = c(-1, 0, 11), b = c(5, 9, 12)
)
zz \%>\%
  as_table() \%>\%
  as_rtf(
    file = tempfile(fileext = ".rtf"),
    title = "Power/Type I Error and Expected Sample Size for a Group Sequential Design"
  )

safety_design <- binomialSPRT(
  p0 = .04, p1 = .1, alpha = .04, beta = .2, minn = 4, maxn = 75
)
safety_power <- gsBinomialExact(
  k = length(safety_design$n.I),
  theta = seq(.02, .16, .02),
  n.I = safety_design$n.I,
  a = safety_design$lower$bound,
  b = safety_design$upper$bound
)
safety_power \%>\%
  as_table() \%>\%
  as_rtf(
    file = tempfile(fileext = ".rtf"),
    theta_label = "Underlying\nAE Rate",
    prob_decimals = 3,
    bound_label = c("Low Rate", "High Rate")
  )
# as_rtf for gsBoundSummary
xgs <- gsSurv(lambdaC = .2, hr = .5, eta = .1, T = 2, minfup = 1.5)
gsBoundSummary(xgs, timename = "Year", tdigits = 1) \%>\% as_rtf(file = tempfile(fileext = ".rtf"))

ss <- nSurvival(
  lambda1 = .2, lambda2 = .1, eta = .1, Ts = 2, Tr = .5,
  sided = 1, alpha = .025, ratio = 2
)
xs <- gsDesign(nFixSurv = ss$n, n.fix = ss$nEvents, delta1 = log(ss$lambda2 / ss$lambda1))
gsBoundSummary(xs, logdelta = TRUE, ratio = ss$ratio) \%>\% as_rtf(file = tempfile(fileext = ".rtf"))

xs <- gsDesign(nFixSurv = ss$n, n.fix = ss$nEvents, delta1 = log(ss$lambda2 / ss$lambda1))
gsBoundSummary(xs, logdelta = TRUE, ratio = ss$ratio) \%>\% 
  as_rtf(file = tempfile(fileext = ".rtf"),
  footnote_specify = "Z",
  footnote_text = "Z-Score")
}
\seealso{
\code{vignette("binomialSPRTExample")}
}
