% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/historical.R
\name{binary_distance}
\alias{binary_distance}
\title{Binary Distance of a Network Path}
\usage{
binary_distance(sociomatrix, path)
}
\arguments{
\item{sociomatrix}{a nonnegative, real valued sociomatrix.}

\item{path}{an integer vector of node indices from \code{sociomatrix}.}
}
\description{
Calculates the binary distance of a user-specified network path through a network,
if all edges exist. Otherwise, returns \code{Inf} to signify infinite distance.
}
\examples{
## Calculate binary distance along a path in a sociomatrix
binary_distance(YangKnoke01, path = c(1,2,5))

## This path doesn't exist
binary_distance(YangKnoke01, path = c(1,2,4,5))

}
