% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distribution-helpers.R
\name{nb_theta}
\alias{nb_theta}
\alias{nb_theta.gam}
\title{Negative binomial parameter theta}
\usage{
nb_theta(model)

\method{nb_theta}{gam}(model)
}
\arguments{
\item{model}{a fitted model.}
}
\value{
A numeric vector of length 1 containing the estimated value of
theta.
}
\description{
Negative binomial parameter theta
}
\section{Methods (by class)}{
\itemize{
\item \code{nb_theta(gam)}: Method for class \code{"gam"}

}}
\examples{
load_mgcv()
df <- data_sim("eg1", n = 500, dist = "poisson", scale = 0.1, seed = 6)

m <- gam(y ~ s(x0, bs = "cr") + s(x1, bs = "cr") + s(x2, bs = "cr") +
  s(x3, bs = "cr"), family = nb, data = df, method = "REML")
## IGNORE_RDIFF_BEGIN
nb_theta(m)
## IGNORE_RDIFF_END
}
