% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bc_test_cond.R
\name{bc_test_cond}
\alias{bc_test_cond}
\title{Conditional Granger-causality test of Breitung and Candelon (2006)}
\usage{
bc_test_cond(x, y, z, ic.chosen = "SC", max.lag = min(4, length(x) -
  1), plot = F, type.chosen = "none", p = 0, conf = 0.95)
}
\arguments{
\item{x}{univariate time series.}

\item{y}{univariate time series (of the same length of \verb{x}).}

\item{z}{univariate time series (of the same length of \verb{x}).}

\item{ic.chosen}{estimation method parameter \verb{ic} to be passed to function \link[vars]{VAR} of
package \href{https://CRAN.R-project.org/package=vars}{vars}. Defaults to ''SC'' (Schwarz criterion). Alternatives are \verb{c(''AIC'',''HQ'',''SC'',''FPE'')}.}

\item{max.lag}{maximum number of lags \verb{lag.max} to be passed to function \code{\link[vars]{VAR}}.
Defaults to \verb{min(4, length(x) - 1)}.}

\item{plot}{logical; if TRUE, it returns the plot of conditional Granger-causality
spectrum. Defaults to FALSE.}

\item{type.chosen}{parameter \verb{type} to be passed to function \code{\link[vars]{VAR}}.}

\item{p}{parameter \verb{p} to be passed to function \link[vars]{VAR}.
It corresponds to the number of lags of the second VAR model. Defaults to 0.}

\item{conf}{prescribed confidence level. It defaults to 0.95.}
}
\value{
\verb{frequency}: frequencies used by Fast Fourier Transform.

\verb{n}: time series length.

\verb{confidence_level}: prescribed confidence level.

\verb{significant_frequencies}: frequencies at which the test is significant..

\verb{F-test}: computed F-test at each frequency.

\verb{F-threshold}: F-threshold at each frequency under prescribed confidence level.

\verb{roots}: roots of the estimated VAR model.

\verb{delays}: delays of the estimated VAR model.

The result is returned invisibly if plot is TRUE.
}
\description{
Inference on the conditional Granger-causality spectrum is provided by
	the parametric test of Breitung and Candelon (2006).
}
\details{
\verb{bc_test_cond} calculates the test of Breitung and Candelon (2006) on the conditional Granger-causality 
	of a time series \verb{x} (effect variable) on a time series \verb{z} (conditioning variable) respect to a time series \verb{y} (cause variable). 
It requires package \href{https://CRAN.R-project.org/package=vars}{vars}.
}
\examples{
	RealGdp.rate.ts<-euro_area_indicators[,1]
	m3.rate.ts<-euro_area_indicators[,2]
	hicp.rate.ts<-euro_area_indicators[,4]	
	cond_bc<-bc_test_cond(RealGdp.rate.ts,m3.rate.ts,hicp.rate.ts,ic.chosen="SC",max.lag=2)
}
\references{
Breitung, J., Candelon, B., 2006. Testing for short- and long-run causality: A frequency-domain approach. 
	\emph{Journal of Econometrics}. \bold{132}, 2, 363--378.

Farne', M., Montanari, A., 2018. A bootstrap test to detect prominent Granger-causalities across frequencies. 
<arXiv:1803.00374>, \emph{Submitted}.
}
\seealso{
\code{\link[vars]{VAR}}.
}
\author{
Matteo Farne', Angela Montanari, \email{matteo.farne2@unibo.it}
}
