% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extractors.R
\name{nPars}
\alias{nPars}
\title{Number of Parameters}
\usage{
nPars(gpModel)
}
\arguments{
\item{gpModel}{object of class GPPM.}
}
\value{
Number of parameters as a numeric.
}
\description{
Extracts the number of parameters from a GPPM.
}
\examples{
\donttest{
data("demoLGCM")
lgcm <- gppm('muI+muS*t','varI+covIS*(t+t#)+varS*t*t#+(t==t#)*sigma',
        demoLGCM,'ID','y')
numberParas <- nPars(lgcm)
}
}
\seealso{
Other functions to extract from a GPPM: \code{\link{SE}},
  \code{\link{coef.GPPM}}, \code{\link{confint.GPPM}},
  \code{\link{covf}}, \code{\link{datas}},
  \code{\link{fitted.GPPM}}, \code{\link{getIntern}},
  \code{\link{logLik.GPPM}}, \code{\link{maxnObs}},
  \code{\link{meanf}}, \code{\link{nObs}},
  \code{\link{nPers}}, \code{\link{nPreds}},
  \code{\link{parEsts}}, \code{\link{pars}},
  \code{\link{preds}}, \code{\link{vcov.GPPM}}
}
