% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights.R
\name{factor_weights}
\alias{factor_weights}
\alias{update_weights}
\title{Factor weights}
\usage{
factor_weights(r)

update_weights(x, w = NULL)
}
\arguments{
\item{r}{A finite number giving the order of the generalized mean.}

\item{x}{A strictly positive numeric vector.}

\item{w}{A strictly positive numeric vector of weights, the same length as
\code{x}. The default is to equally weight each element of \code{x}.}
}
\value{
\code{factor_weights()} return a function:

\preformatted{function(x, w = NULL){...}}

\code{update_weights()} returns a numeric vector the same length as \code{x}.
}
\description{
Factor weights to turn the generalized mean of a product into the product
of generalized means. Useful for price-updating the weights in a
generalized-mean index.
}
\details{
The function \code{factor_weights(r)} returns a function to compute weights
\code{u(x, w)} such that

\preformatted{generalized_mean(r)(x * y, w) ==
  generalized_mean(r)(x, w) * generalized_mean(r)(y, u(x, w))}

This generalizes the result in section C.5 of Chapter 9 of the PPI Manual
for chaining the Young index, and gives a way to chain generalized-mean
price indexes over time.

Factoring weights with \code{r = 1} sometimes gets called price-updating
weights; \code{update_weights()} simply calls \code{factor_weights(1)()}.

Factoring weights return a value that is the same length as \code{x},
so any missing values in \code{x} or the weights will return \code{NA}.
Unless all values are \code{NA}, however, the result for will still satisfy
the above identity when \code{na.rm = TRUE}.
}
\examples{
x <- 1:3
y <- 4:6
w <- 3:1
# Factor the harmonic mean by chaining the calculation

harmonic_mean(x * y, w)
harmonic_mean(x, w) * harmonic_mean(y, factor_weights(-1)(x, w))

# The common case of an arithmetic mean

arithmetic_mean(x * y, w)
arithmetic_mean(x, w) * arithmetic_mean(y, update_weights(x, w))

# In cases where x and y have the same order, Chebyshev's
# inequality implies that the chained calculation is too small

arithmetic_mean(x * y, w) >
  arithmetic_mean(x, w) * arithmetic_mean(y, w)

}
\references{
ILO, IMF, OECD, UNECE, and World Bank. (2004).
\emph{Producer Price Index Manual: Theory and Practice}.
International Monetary Fund.
}
\seealso{
\code{\link[=generalized_mean]{generalized_mean()}} for the generalized mean.

\code{\link[=grouped]{grouped()}} to make these functions operate on grouped data.

Other weights functions: 
\code{\link{scale_weights}()},
\code{\link{transmute_weights}()}
}
\concept{weights functions}
