% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/future.R
\name{makeDockerClusterPSOCK}
\alias{makeDockerClusterPSOCK}
\title{Make the Docker cluster on Google Compute Engine}
\usage{
makeDockerClusterPSOCK(
  workers,
  docker_image = "rocker/r-parallel",
  rscript = c("docker", "run", "--net=host", docker_image, "Rscript"),
  rscript_args = NULL,
  install_future = FALSE,
  ...,
  verbose = FALSE
)
}
\arguments{
\item{workers}{The VMs being called upon}

\item{docker_image}{The docker image to use on the cluster}

\item{rscript}{The Rscript command to run on the cluster}

\item{rscript_args}{Arguments to the RScript}

\item{install_future}{Whether to check if future is installed first (not needed if using docker derived from rocker/r-parallel which is recommended)}

\item{...}{Other arguments passed to \link[future]{makeClusterPSOCK}}

\item{verbose}{How much feedback to show}
}
\description{
Called by \link{as.cluster}
}
\author{
Henrik Bengtsson \email{henrikb@braju.com}
}
