% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networks.R
\name{gce_delete_access_config}
\alias{gce_delete_access_config}
\title{Deletes an Access Config, Typically for an External IP Address.}
\usage{
gce_delete_access_config(
  instance,
  access_config = "external-nat",
  network_interface = "nic0",
  project = gce_get_global_project(),
  zone = gce_get_global_zone()
)
}
\arguments{
\item{instance}{Name of the instance resource, or an instance object e.g. from \link{gce_get_instance}}

\item{access_config}{The name of the access config to delete.}

\item{network_interface}{The name of the network interface.}

\item{project}{Project ID for this request, default as set by \link{gce_get_global_project}}

\item{zone}{The name of the zone for this request, default as set by \link{gce_get_global_zone}}
}
\value{
A list of operation objects with pending status
}
\description{
Deletes an Access Config, Typically for an External IP Address.
}
\details{
Authentication scopes used by this function are:
\itemize{
  \item https://www.googleapis.com/auth/cloud-platform
\item https://www.googleapis.com/auth/compute
}
}
\seealso{
\href{https://developers.google.com/compute/docs/reference/latest/}{Google Documentation}
}
