% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/harbor_docker.R
\name{docker_run}
\alias{docker_run}
\title{Run a command in a new container on a host.}
\usage{
docker_run(
  host = localhost,
  image = NULL,
  cmd = NULL,
  name = NULL,
  rm = FALSE,
  detach = FALSE,
  docker_opts = NULL,
  ...
)
}
\arguments{
\item{host}{An object representing the host where the container will be run.}

\item{image}{The name or ID of a docker image.}

\item{cmd}{A command to run in the container.}

\item{name}{A name for the container. If none is provided, a random name will
be used.}

\item{rm}{If \code{TRUE}, remove the container after it finishes. This is
incompatible with \code{detach=TRUE}.}

\item{detach}{If \code{TRUE}, run the container in the background.}

\item{docker_opts}{Options to docker. These are things that come before the
docker command, when run on the command line.}

\item{...}{Other arguments passed to the SSH command for the host}
}
\value{
A \code{container} object. When \code{rm=TRUE}, this function returns
  \code{NULL} instead of a container object, because the container no longer
  exists.
}
\description{
Run a command in a new container on a host.
}
\examples{
\dontrun{
docker_run(localhost, "debian:testing", "echo foo")
#> foo

# Arguments will be concatenated
docker_run(localhost, "debian:testing", c("echo foo", "bar"))
#> foo bar

docker_run(localhost, "rocker/r-base", c("Rscript", "-e", "1+1"))
#> [1] 2
}
}
\author{
Winston Change \email{winston@stdout.org}
}
