% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmnl.methods.R
\name{wtp.gmnl}
\alias{wtp.gmnl}
\title{Compute Willingness-to-pay}
\usage{
wtp.gmnl(object, wrt = NULL, digits = max(3, getOption("digits") - 2))
}
\arguments{
\item{object}{an object of class \code{gmnl}.}

\item{wrt}{a string indicating the variable with respect to which the WTP is computed,}

\item{digits}{number of significant digits to be used for most numbers.}
}
\value{
A coefficient matrix with the WTP point estimates and standard errors.
}
\description{
Compute the willingness-to-pay.
}
\details{
For each coefficient, this function computes both the point estimate and standard error of WTP with respect to the variable specified in the argument \code{wrt}. Specifically, let \eqn{\beta_k} be the coefficient for variable \eqn{k}, then \deqn{WTP_{k}=-\beta_k/\beta_p}


where \eqn{\beta_p} is the coefficient for the variable specified with the argument \code{wrt}. Note that, \code{wtp.gmnl} does not include the negative sign. 


\code{wtp.gmnl} function is a wrapper for the \code{\link[msm]{deltamethod}} function of the \pkg{msm} package.
}
\examples{

## Examples using the Electricity data set from the mlogit package
library(mlogit)
data("Electricity", package = "mlogit")
Electr <- mlogit.data(Electricity, id.var = "id", choice = "choice",
                     varying = 3:26, shape = "wide", sep = "")
                     
## Estimate a conditional logit model
clogit <- gmnl(choice ~ pf + cl + loc + wk + tod + seas| 0,
               data = Electr)
wtp.gmnl(clogit, wrt = "pf")
}
\references{
\itemize{
\item Greene, W. H. (2012). Econometric Analysis, Seventh Edition. Pearson Hall.
\item Train, K. (2009). Discrete Choice Methods with Simulation. Cambridge University Press.
}
}
\seealso{
\code{\link[msm]{deltamethod}} for the estimation of the standard errors.
}
\author{
Mauricio Sarrias.
}
