% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glms.R
\name{localInfluence.glm}
\alias{localInfluence.glm}
\title{Local Influence for Generalized Linear Models}
\usage{
\method{localInfluence}{glm}(
  object,
  type = c("total", "local"),
  perturbation = c("case-weight", "response", "covariate"),
  covariate,
  coefs,
  plot.it = FALSE,
  identify,
  ...
)
}
\arguments{
\item{object}{an object of class \emph{glm}.}

\item{type}{an (optional) character string indicating the type of approach to study the
local influence. The options are: the absolute value of the elements of the eigenvector which corresponds to the maximum absolute eigenvalue ("local"); and the absolute value of the elements of the main diagonal ("total"). By default, \code{type} is set to be "total".}

\item{perturbation}{an (optional) character string indicating the perturbation scheme
to apply. The options are: case weight perturbation of observations ("case-weight"); perturbation of covariates ("covariate"); and perturbation of response ("response"). By default, \code{perturbation} is set to be "case-weight".}

\item{covariate}{an character string which (partially) match with the names of one of
the parameters in the linear predictor. This is only appropriate if \code{perturbation="covariate"}.}

\item{coefs}{an (optional) character string which (partially) match with the names of
some of the parameters in the linear predictor.}

\item{plot.it}{an (optional) logical indicating if the plot of the measures of local
influence is required or just the data matrix in which that plot is based. By default,
\code{plot.it} is set to be FALSE.}

\item{identify}{an (optional) integer indicating the number of observations to identify
on the plot of the measures of local influence. This is only appropriate if
\code{plot.it=TRUE}.}

\item{...}{further arguments passed to or from other methods. If \code{plot.it=TRUE}
then \code{...} may be used to include graphical parameters to customize the plot. For example, \code{col}, \code{pch}, \code{cex}, \code{main}, \code{sub}, \code{xlab}, \code{ylab}.}
}
\value{
A matrix as many rows as observations in the sample and one column with the values of the measures of local influence.
}
\description{
Computes some measures and, optionally, display	graphs of them to perform
influence analysis based on the approaches described in Cook (1986).
}
\references{
Cook, D. (1986) Assessment of Local Influence. \emph{Journal of the Royal Statistical Society: Series B (Methodological)} 48, 133-155.

Thomas, W. and Cook, D. (1989) Assessing Influence on Regression Coefficients in Generalized Linear Models. \emph{Biometrika} 76, 741-749.
}
