% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_issues.R
\name{get_issues}
\alias{get_issues}
\title{Retrieve all issues on a repository}
\usage{
get_issues(repo_name, how_many = "all", git_pat = NULL, verbose = TRUE)
}
\arguments{
\item{repo_name}{the name of the repository to retrieve issues from, e.g. jhudsl/OTTR_Template}

\item{how_many}{put the number of how many you would like returned. If all, put "all". By default will return all issues.}

\item{git_pat}{A personal access token from GitHub. Only necessary if the
repository being checked is a private repository.}

\item{verbose}{TRUE/FALSE do you want more progress messages?}
}
\value{
A data frame that contains information about the issues from the given repository
}
\description{
Given a repository name, get a list of issues.
}
\examples{
 \dontrun{

# First, set up your GitHub credentials using `usethis::gitcreds_set()`.
# Get a GitHub personal access token (PAT)
usethis::create_github_token()

# Give this token to `gitcreds_set()`
gitcreds::gitcreds_set()

# Now you can retrieve issues
issues_df <- get_issues("jhudsl/OTTR_Template")
# Alternatively, you can supply the GitHub PAT directly
# to the function to avoid doing the steps above.
issues_df <- get_issues("jhudsl/OTTR_Template", git_pat = "gh_somepersonalaccesstokenhere")
}
}
