% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggdensitree.R
\name{ggdensitree}
\alias{ggdensitree}
\title{ggdensitree}
\usage{
ggdensitree(
  data = NULL,
  mapping = NULL,
  layout = "slanted",
  tip.order = "mode",
  align.tips = TRUE,
  jitter = 0,
  ...
)
}
\arguments{
\item{data}{a list of phylo objects or any object with an as.phylo and fortify method}

\item{mapping}{aesthetic mapping}

\item{layout}{one of 'slanted', 'rectangluar', 'fan', 'circular' or 'radial' (default: 'slanted')}

\item{tip.order}{the order of the tips by a character vector of taxa names; or an integer, N, to order the tips by the order of the tips in the Nth tree; 'mode' to order the tips by the most common order; 'mds' to order the tips based on MDS of the path length between the tips;  or 'mds_dist' to order the tips based on MDS of the distance between the tips (default: 'mode')}

\item{align.tips}{TRUE (default) to align trees by their tips and FALSE to align trees by their root}

\item{jitter}{deviation to jitter tips}

\item{...}{additional parameters passed to fortify, ggtree and geom_tree}
}
\value{
tree layer
}
\description{
drawing phylogenetic trees from list of phylo objects
}
\details{
The trees plotted by 'ggdensitree()' will be stacked on top of each other and the
structures of the trees will be rotated to ensure the consistency of the tip order.
}
\examples{
require(ape)
require(dplyr)
require(tidyr)

# Plot multiple trees with aligned tips
trees <- list(read.tree(text="((a:1,b:1):1.5,c:2.5);"), read.tree(text="((a:1,c:1):1,b:2);"));
ggdensitree(trees) + geom_tiplab()

# Plot multiple trees with aligned tips with tip labels and separate tree colors
trees.fort <- list(trees[[1]] \%>\% fortify \%>\% mutate(tree="a"), trees[[2]] \%>\% fortify \%>\% mutate(tree="b"));
ggdensitree(trees.fort, aes(colour=tree)) + geom_tiplab(colour='black')


# Generate example data
set.seed(1)
random.trees <- rmtree(5, 10)
time.trees <- lapply(seq_along(random.trees), function(i) {
 	tree <- random.trees[[i]]
 	tree$tip.label <- paste0("t", 1:10)
	dates <- estimate.dates(tree, 1:10, mu=1, nsteps=1)
	tree$edge.length <- dates[tree$edge[, 2]] - dates[tree$edge[, 1]]
	fortify(tree) \%>\% mutate(tree=factor(i, levels=as.character(1:10)))
})

# Plot multiple trees with aligned tips from multiple time points
ggdensitree(time.trees, aes(colour=tree), tip.order=paste0("t", 1:10)) + geom_tiplab(colour='black')


# Read example data
example.trees <- read.tree(system.file("examples", "ggdensitree_example.tree", package="ggtree"))

# Compute OTU
grp <- list(A = c("a.t1", "a.t2", "a.t3", "a.t4"), B = c("b.t1", "b.t2", "b.t3", "b.t4"), C = c("c.t1", "c.t2", "c.t3", "c.t4"))
otu.trees <- lapply(example.trees, groupOTU, grp)

# Plot multiple trees colored by OTU
ggdensitree(otu.trees, aes(colour=group), alpha=1/6, tip.order='mds') + scale_colour_manual(values=c("black", "red", "green", "blue"))
}
\references{
For more detailed demonstration of this function, please refer to chapter 4.4.2 of
\emph{Data Integration, Manipulation and Visualization of Phylogenetic Trees}
\url{http://yulab-smu.top/treedata-book/index.html} by Guangchuang Yu.
}
\author{
Yu Guangchuang, Bradley R. Jones
}
