% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_strip.R
\name{geom_strip}
\alias{geom_strip}
\title{geom_strip}
\usage{
geom_strip(
  taxa1,
  taxa2,
  label,
  offset = 0,
  offset.text = 0,
  align = TRUE,
  barsize = 0.5,
  extend = 0,
  fontsize = 3.88,
  angle = 0,
  geom = "text",
  hjust = 0,
  color = "black",
  fill = NA,
  family = "sans",
  parse = FALSE,
  ...
)
}
\arguments{
\item{taxa1}{taxa1}

\item{taxa2}{taxa2}

\item{label}{add label alongside the bar (optional)}

\item{offset}{offset of bar and text from the clade}

\item{offset.text}{offset of text from bar}

\item{align}{logical, whether to align bars to the most distant bar ,defaults to "TRUE"
Note that if "FALSE", the bars might cross the tree}

\item{barsize}{set size of the bar}

\item{extend}{extend bar length vertically}

\item{fontsize}{set size of the text}

\item{angle}{set the angle of text}

\item{geom}{one of 'text' or 'label'}

\item{hjust}{adjust the horizonal position of the bar}

\item{color}{set color for bar and label}

\item{fill}{set color to fill label background, only work with geom='label'}

\item{family}{"sans" by default, can be any supported font}

\item{parse}{logical, whether to parse labels, if "TRUE", the labels will be parsed into expressions, defaults to "FALSE"}

\item{...}{additional parameter}
}
\value{
ggplot layers
}
\description{
annotate associated taxa (from taxa1 to taxa2, can be Monophyletic, Polyphyletic or Paraphyletc Taxa) with bar and (optional) text label
}
\examples{
library(ggtree)
tr<- rtree(15)
x <- ggtree(tr)
x + geom_strip(13, 1, color = "red") + geom_strip(3, 7, color = "blue")
}
\references{
For more detailed demonstration of this function, please refer to chapter 5.2.1 of
\emph{Data Integration, Manipulation and Visualization of Phylogenetic Trees}
\url{http://yulab-smu.top/treedata-book/index.html} by Guangchuang Yu.
}
\author{
Guangchuang Yu
}
