% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-d3.R
\name{pal_d3}
\alias{pal_d3}
\title{D3.js Color Palettes}
\usage{
pal_d3(
  palette = c("category10", "category20", "category20b", "category20c"),
  alpha = 1
)
}
\arguments{
\item{palette}{Palette type.
There are 4 available options:
\code{"category10"} (10-color palette);
\code{"category20"} (20-color palette);
\code{"category20b"} (20-color palette);
\code{"category20c"} (20-color palette).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}
}
\description{
Color palettes based on the colors used by D3.js.
}
\examples{
library("scales")
show_col(pal_d3("category10")(10))
show_col(pal_d3("category20")(20))
show_col(pal_d3("category20b")(20))
show_col(pal_d3("category20c")(20))
}
\references{
\url{https://github.com/d3/d3-3.x-api-reference/blob/master/Ordinal-Scales.md}
}
\author{
Nan Xiao <\email{me@nanx.me}> |
<\href{https://nanx.me}{https://nanx.me}>
}
