% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_manual.R
\name{scale_x_manual}
\alias{scale_x_manual}
\alias{scale_y_manual}
\title{Manual position scales}
\usage{
scale_x_manual(values, c_limits = NULL, position = "bottom", ...)

scale_y_manual(values, c_limits = NULL, position = "left", ...)
}
\arguments{
\item{values}{A \code{numeric} vector with the same length as unique values.
Alternatively, a function that accepts the limits (unique values) as
determined from the data and returns a \code{numeric} vector parallel to the
input.}

\item{c_limits}{Either \code{NULL} (default) to accept the range of \code{values} as
the continuous limits, or a \code{numeric(2)} to set custom continuous limits.}

\item{position}{For position scales, The position of the axis.
\code{left} or \code{right} for y axes, \code{top} or \code{bottom} for x axes.}

\item{...}{
  Arguments passed on to \code{\link[ggplot2:discrete_scale]{ggplot2::discrete_scale}}
  \describe{
    \item{\code{scale_name}}{The name of the scale that should be used for error messages
associated with this scale.}
    \item{\code{name}}{The name of the scale. Used as the axis or legend title. If
\code{waiver()}, the default, the name of the scale is taken from the first
mapping used for that aesthetic. If \code{NULL}, the legend title will be
omitted.}
    \item{\code{breaks}}{One of:
\itemize{
\item \code{NULL} for no breaks
\item \code{waiver()} for the default breaks (the scale limits)
\item A character vector of breaks
\item A function that takes the limits as input and returns breaks
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{labels}}{One of:
\itemize{
\item \code{NULL} for no labels
\item \code{waiver()} for the default labels computed by the
transformation object
\item A character vector giving labels (must be same length as \code{breaks})
\item An expression vector (must be the same length as breaks). See ?plotmath for details.
\item A function that takes the breaks as input and returns labels
as output. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{limits}}{One of:
\itemize{
\item \code{NULL} to use the default scale values
\item A character vector that defines possible values of the scale and their
order
\item A function that accepts the existing (automatic) values and returns
new ones. Also accepts rlang \link[rlang:as_function]{lambda} function
notation.
}}
    \item{\code{expand}}{For position scales, a vector of range expansion constants used to add some
padding around the data to ensure that they are placed some distance
away from the axes. Use the convenience function \code{\link[ggplot2:expansion]{expansion()}}
to generate the values for the \code{expand} argument. The defaults are to
expand the scale by 5\% on each side for continuous variables, and by
0.6 units on each side for discrete variables.}
    \item{\code{na.translate}}{Unlike continuous scales, discrete scales can easily show
missing values, and do so by default. If you want to remove missing values
from a discrete scale, specify \code{na.translate = FALSE}.}
    \item{\code{na.value}}{If \code{na.translate = TRUE}, what aesthetic value should the
missing values be displayed as? Does not apply to position scales
where \code{NA} is always placed at the far right.}
    \item{\code{drop}}{Should unused factor levels be omitted from the scale?
The default, \code{TRUE}, uses the levels that appear in the data;
\code{FALSE} uses all the levels in the factor.}
    \item{\code{guide}}{A function used to create a guide or its name. See
\code{\link[ggplot2:guides]{guides()}} for more information.}
    \item{\code{super}}{The super class to use for the constructed scale}
  }}
}
\value{
A \verb{<ScaleManualPosition>} object that can be added to a plot.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{scale_x_manual()} and \code{scale_y_manual()} are hybrid discrete and continuous
position scales for the \code{x} and \code{y} aesthetics. These accept input like
\link[ggplot2:scale_discrete]{discrete scales}, but may map these discrete
values to continuous values that needn't be equally spaced.
}
\details{
Many thanks to Constantin Ahlmann-Eltze for discussion and suggesting
the adoption of this functionality in ggh4x.
}
\note{
There currently is a known bug wherein a \code{c_limits} cannot be applied
correctly when that range is within the range of the discrete limits.
}
\examples{
# A boxplot with interactions
p <- ggplot(mpg, aes(interaction(year, cyl), displ)) +
  geom_boxplot()

# Manually setting positions
p + scale_x_manual(values = c(1, 2, 4, 6, 7, 9, 10))

# Using a function to separate grouped labels
p + scale_x_manual(values = sep_discrete())

# Expanding the continuous limits
p + scale_x_manual(values = sep_discrete(), c_limits = c(NA, 15))

# Together with grouped axis
p + scale_x_manual(values = sep_discrete(), guide = guide_axis_nested())
}
\seealso{
\code{\link[=sep_discrete]{sep_discrete()}}
}
