% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method.R
\name{method_kde}
\alias{method_kde}
\title{Bivariate kernel density HDR estimator}
\usage{
method_kde(h = NULL, adjust = c(1, 1))
}
\arguments{
\item{h}{Bandwidth (vector of length two). If \code{NULL}, estimated
using \code{\link[MASS:bandwidth.nrd]{MASS::bandwidth.nrd()}}.}

\item{adjust}{A multiplicative bandwidth adjustment to be used if 'h' is
'NULL'. This makes it possible to adjust the bandwidth while still
using the a bandwidth estimator. For example, \code{adjust = 1/2} means
use half of the default bandwidth.}
}
\description{
Function used to specify bivariate kernel density estimator
for \code{get_hdr()} and layer functions (e.g. \code{geom_hdr()}).
}
\details{
For more details on the use and implementation of the \verb{method_*()} functions,
see \code{vignette("method", "ggdensity")}.
}
\examples{
set.seed(1)
df <- data.frame(x = rnorm(1e3, sd = 3), y = rnorm(1e3, sd = 3))

ggplot(df, aes(x, y)) +
  geom_hdr(method = method_kde()) +
  geom_point(size = 1)

# The defaults of `method_kde()` are the same as the estimator for `ggplot2::geom_density_2d()`
ggplot(df, aes(x, y)) +
  geom_density_2d_filled() +
  geom_hdr_lines(method = method_kde(), probs = seq(.1, .9, by = .1)) +
  theme(legend.position = "none")

# The bandwidth of the estimator can be set directly with `h` or scaled with `adjust`
ggplot(df, aes(x, y)) +
  geom_hdr(method = method_kde(h = 1)) +
  geom_point(size = 1)

ggplot(df, aes(x, y)) +
  geom_hdr(method = method_kde(adjust = 1/2)) +
  geom_point(size = 1)

# Can also be used with `get_hdr()` for numerical summary of HDRs
res <- get_hdr(df, method = method_kde())
str(res)

}
