% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weave.R
\name{weave_annotate_defaults}
\alias{weave_annotate_defaults}
\title{Update a series of annotate defaults}
\usage{
weave_annotate_defaults(colour = lightness[2])
}
\arguments{
\item{colour}{A hex colour. Defaults to \code{lightness[2]}.}
}
\value{
Updated annotation geom defaults
}
\description{
Update a series of geom defaults commonly used for annotation (i.e. \verb{*_vline}, \verb{*_hline}, \verb{*_abline}, \verb{*_curve}, \verb{*_text} and \verb{*_label}).
}
\examples{
library(ggplot2)
library(ggblanket)
library(palmerpenguins)

set_blanket()
weave_annotate_defaults("#bc5090")

penguins |>
  gg_point(
    x = flipper_length_mm,
    y = body_mass_g,
    x_breaks = scales::breaks_pretty(3),
  ) +
  geom_vline(xintercept = 200) +
  annotate("text", x = I(0.25), y = I(0.75), label = "Here")

}
