% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_seq.R
\name{replace_seq}
\alias{replace_seq}
\title{Replace a sequence of elements in a vector}
\usage{
replace_seq(x, ..., keep_nth = 2, offset = 0, replacement = "")
}
\arguments{
\item{x}{A vector.}

\item{...}{If numeric, other arguments passed to the \code{scales::comma} function.}

\item{keep_nth}{The increment of elements to keep as is. Defaults to \code{2}.}

\item{offset}{An offset to start at the intended offset. Defaults to \code{0}. Possible replaces are \code{-1} to (\code{keep_nth - 2})}

\item{replacement}{The replacement value to replace non-kept elements with. Defaults to \code{""}.}
}
\value{
A vector.
}
\description{
Keep every nth element in a vector, and replace the rest with a value such as \code{""}.
}
\examples{
replace_seq(seq(1000, 7000, 1000))
replace_seq(seq(1000, 7000, 1000), offset = -1)
replace_seq(seq(1000, 7000, 1000), keep_nth = 3)
replace_seq(LETTERS[1:12])

}
