% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_ribbon.R
\name{gg_ribbon}
\alias{gg_ribbon}
\title{Ribbon ggplot}
\usage{
gg_ribbon(
  data = NULL,
  ...,
  stat = "identity",
  position = "identity",
  coord = ggplot2::coord_cartesian(clip = "off"),
  mode = NULL,
  x = NULL,
  xmin = NULL,
  xmax = NULL,
  xend = NULL,
  y = NULL,
  ymin = NULL,
  ymax = NULL,
  yend = NULL,
  z = NULL,
  col = NULL,
  facet = NULL,
  facet2 = NULL,
  group = NULL,
  subgroup = NULL,
  label = NULL,
  text = NULL,
  sample = NULL,
  mapping = NULL,
  x_breaks = NULL,
  x_expand = NULL,
  x_expand_limits = NULL,
  x_labels = NULL,
  x_limits = NULL,
  x_oob = scales::oob_keep,
  x_position = "bottom",
  x_title = NULL,
  x_transform = NULL,
  y_breaks = NULL,
  y_expand = NULL,
  y_expand_limits = NULL,
  y_labels = NULL,
  y_limits = NULL,
  y_oob = scales::oob_keep,
  y_position = "left",
  y_title = NULL,
  y_transform = NULL,
  col_breaks = NULL,
  col_expand_limits = NULL,
  col_labels = NULL,
  col_legend_ncol = NULL,
  col_legend_nrow = NULL,
  col_legend_rev = FALSE,
  col_limits = NULL,
  col_oob = scales::oob_keep,
  col_pal = NULL,
  col_pal_na = "darkgrey",
  col_rescale = scales::rescale(),
  col_steps = FALSE,
  col_title = NULL,
  col_transform = NULL,
  facet_axes = NULL,
  facet_axis_labels = "margins",
  facet_labels = NULL,
  facet_labels_position = "top",
  facet_labels_switch = NULL,
  facet_layout = NULL,
  facet_ncol = NULL,
  facet_nrow = NULL,
  facet_scales = "fixed",
  facet_space = "fixed",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  titles_to_case = snakecase::to_sentence_case
)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{...}{Other arguments passed to within a \code{params} list in \code{layer()}.}

\item{stat}{A statistical transformation to use on the data. A snakecase character string of a ggproto Stat subclass object minus the Stat prefix (e.g. \code{"identity"}).}

\item{position}{A position adjustment. A snakecase character string of a ggproto Position subclass object minus the Position prefix (e.g. \code{"identity"}), or a \verb{position_*()} function that outputs a ggproto Position subclass object (e.g. \code{ggplot2::position_identity()}).}

\item{coord}{A coordinate system. A \verb{coord_*()} function that outputs a constructed ggproto Coord subclass object (e.g. \code{\link[ggplot2:coord_cartesian]{ggplot2::coord_cartesian()}}).}

\item{mode}{A \verb{*_mode_*} theme (e.g. \code{\link[=light_mode_t]{light_mode_t()}}, \code{\link[=grey_mode_r]{grey_mode_r()}}, or \code{\link[=dark_mode_r]{dark_mode_r()}}). This argument adds the theme with side-effects, as the \verb{gg_*} function will removes selected gridlines/axis-line/ticks. To avoid these side-effects, \code{+} the theme on to the output of \verb{gg_*}.}

\item{x, xmin, xmax, xend, y, ymin, ymax, yend, z, col, facet, facet2, group, subgroup, label, text, sample}{An unquoted aesthetic variable.}

\item{mapping}{A set of additional aesthetic mappings in \code{\link[ggplot2:aes]{ggplot2::aes()}}. Intended primarily for non-supported aesthetics (e.g. \code{shape}, \code{linetype}, \code{linewidth}, or \code{size}), but can also be used for delayed evaluation etc.}

\item{x_breaks, y_breaks, col_breaks}{A \verb{scales::breaks_*} function (e.g. \code{\link[scales:breaks_pretty]{scales::breaks_pretty()}}), or a vector of breaks.}

\item{x_expand, y_expand}{Padding to the limits with the \code{\link[ggplot2:expansion]{ggplot2::expansion()}} function, or a vector of length 2 (e.g. \code{c(0, 0)}).}

\item{x_expand_limits, y_expand_limits, col_expand_limits}{For a continuous variable, any values that the limits should encompass (e.g. \code{0}). For a discrete scale, manipulate the data instead with \code{forcats::fct_expand}.}

\item{x_labels, y_labels, col_labels, facet_labels}{A function that takes the breaks as inputs (e.g. \verb{\\(x) stringr::str_to_sentence(x)} or \code{\link[scales:label_number]{scales::label_comma()}}), or a vector of labels (Note this must be named for \code{facet_labels}).}

\item{x_limits, y_limits, col_limits}{For a continuous scale, a vector of length 2 to determine the limits of the scale. For a discrete scale, manipulate the data instead with \code{factor}, \code{forcats::fct_expand} or \code{forcats::fct_drop}.}

\item{x_oob, y_oob, col_oob}{For a continuous scale, a \verb{scales::oob_*} function of how to handle values outside of limits. Defaults to \code{scales::oob_keep}.}

\item{x_position, y_position}{The position of the axis (i.e. \code{"left"}, \code{"right"}, \code{"bottom"} or \code{"top"}).If using \code{y_position = "top"} with a \verb{*_mode_*} theme, add \code{caption = ""} or \code{caption = "\\n"}.}

\item{x_title, y_title, col_title}{Axis title string. Use \code{+ ggplot2::labs(... = NULL)} for no title.}

\item{x_transform, y_transform, col_transform}{For a continuous scale, a transformation object (e.g. \code{\link[scales:transform_log]{scales::transform_log10()}}) or character string of this minus the \code{transform_} prefix (e.g. \code{"log10"}).}

\item{col_legend_ncol, col_legend_nrow}{The number of columns and rows in a legend guide.}

\item{col_legend_rev}{\code{TRUE} or \code{FALSE} of whether to reverse the elements of a legend guide. Defaults to \code{FALSE}.}

\item{col_pal}{Colours to use. A character vector of hex codes (or names).}

\item{col_pal_na}{Colour to use for \code{NA} values. A character vector of a hex code (or name).}

\item{col_rescale}{For a continuous variable, a \code{scales::rescale()} function.}

\item{col_steps}{For a continuous variable, \code{TRUE} or \code{FALSE} of whether to colour in steps. Defaults to \code{FALSE}.}

\item{facet_axes}{Whether to add interior axes and ticks with \code{"margins"}, \code{"all"}, \code{"all_x"}, or \code{"all_y"}.}

\item{facet_axis_labels}{Whether to add interior axis labels with \code{"margins"}, \code{"all"}, \code{"all_x"}, or \code{"all_y"}.}

\item{facet_labels_position}{When the facet layout is \code{"wrap"}, the position of the facet labels. Either \code{"top"}, \code{"right"}, \code{"bottom"} or \code{"left"}.}

\item{facet_labels_switch}{When the facet layout is \code{"grid"}, whether to switch the facet labels to the opposite side of the plot. Either \code{"x"}, \code{"y"} or \code{"both"}.}

\item{facet_layout}{Whether the layout is to be \code{"wrap"} or \code{"grid"}. If \code{NULL} and a single \code{facet} (or \code{facet2}) argument is provided, then defaults to \code{"wrap"}. If \code{NULL} and both facet and facet2 arguments are provided, defaults to \code{"grid"}.}

\item{facet_ncol, facet_nrow}{The number of columns and rows of facet panels. Only applies to a facet layout of \code{"wrap"}.}

\item{facet_scales}{Whether facet scales should be \code{"fixed"} across facets, \code{"free"} in both directions, or free in just one direction (i.e. \code{"free_x"} or \code{"free_y"}). Defaults to \code{"fixed"}.}

\item{facet_space}{When the facet layout is \code{"grid"} and facet scales are not \code{"fixed"}, whether facet space should be \code{"fixed"} across facets, \code{"free"} to be proportional in both directions, or free to be proportional in just one direction (i.e. \code{"free_x"} or \code{"free_y"}). Defaults to \code{"fixed"}.}

\item{title}{Title string.}

\item{subtitle}{Subtitle string.}

\item{caption}{Caption title string.}

\item{titles_to_case}{A function to format unspecified titles_to_case. Defaults to \code{snakecase::to_sentence_case}.}
}
\value{
A ggplot object.
}
\description{
Create a ribbon ggplot with a wrapper around \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} + \link[ggplot2:geom_ribbon]{geom_ribbon()}
}
\examples{
library(ggplot2)
library(dplyr)

set_blanket()

data.frame(year = 1875:1972, level = as.vector(LakeHuron)) |>
  mutate(level_min = level - 1, level_max = level + 1) |>
  gg_ribbon(
    x = year,
    ymin = level_min,
    ymax = level_max,
    colour = NA,
    x_labels = \(x) x,
    y_title = "Level",
  ) +
  geom_line(
    mapping = aes(y = level),
  )

}
