% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility_functions.R
\name{MinMaxGC}
\alias{MinMaxGC}
\alias{max_gc}
\alias{min_gc}
\title{Maxima and Minima}
\usage{
max_gc(..., na.rm = TRUE, allmissing_NA = TRUE)

min_gc(..., na.rm = TRUE, allmissing_NA = TRUE)
}
\arguments{
\item{...}{numeric or character arguments}

\item{na.rm}{a logical indicating whether missing values should be removed.}

\item{allmissing_NA}{a logical indicating whether \code{NA} should be
returned when there are no non-missing arguments
passed to \code{min} or \code{max} (often because
\code{na.rm = TRUE} but all values are \code{NA})}
}
\value{
If \code{allmissing_NA = FALSE}, identical to \code{min} or 
   \code{max}.
   
   If \code{allmissing_NA = TRUE}, identical to \code{min} or 
   \code{max} except that, in cases where \code{min} or 
   \code{max} would return an infinite value and raise a warning because
   there are no non-missing arguments, \code{min_gc} and
   \code{max_gc} return \code{NA}
}
\description{
Returns the maxima and minima of the input values.
}
\details{
These functions are wrappers for \code{min} and \code{max},
with the additional argument \code{allmissing_NA}.
}
