#' Genetic analysis package
#'
#' As is first reported, it is designed as an integrated package for genetic data
#' analysis of both population and family data. Currently, it contains functions for
#' sample size calculations of both population-based and family-based designs, probability
#' of familial disease aggregation, kinship calculation, statistics in linkage analysis,
#' and association analysis involving genetic markers including haplotype analysis with or
#' without environmental covariates. Over years, the package has been developed in-between
#' many projects hence also in line with the name (gap).
#'
#' @details
#' We have incorporated functions for a wide range of problems as shown below.
#'
#' \tabular{ll}{
#' \cr
#' \strong{ANALYSIS}\cr
#' \cr
#' AE3               \tab      AE model using nuclear family trios\cr
#' bt                \tab      Bradley-Terry model for contingency table\cr
#' ccsize            \tab      Power and sample size for case-cohort design\cr
#' cs                \tab      Credibel set\cr
#' fbsize            \tab      Sample size for family-based linkage and association design\cr
#' gc.em             \tab      Gene counting for haplotype analysis\cr
#' gcontrol          \tab      genomic control\cr
#' gcontrol2         \tab      genomic control based on p values\cr
#' gcp               \tab      Permutation tests using GENECOUNTING\cr
#' gc.lambda         \tab      Estimation of the genomic control inflation statistic (lambda)\cr
#' genecounting      \tab      Gene counting for haplotype analysis\cr
#' gif               \tab      Kinship coefficient and genetic index of familiality\cr
#' hap               \tab      Haplotype reconstruction\cr
#' hap.em            \tab      Gene counting for haplotype analysis\cr
#' hap.score         \tab      Score statistics for association of traits with haplotypes\cr
#' htr               \tab      Haplotype trend regression\cr
#' h2.jags           \tab      Heritability estimation based on genomic relationship matrix using JAGS\cr
#' hwe               \tab      Hardy-Weinberg equilibrium test for a multiallelic marker\cr
#' hwe.cc            \tab      A likelihood ratio test of population Hardy-Weinberg equilibrium \cr
#' hwe.hardy         \tab      Hardy-Weinberg equilibrium test using MCMC\cr
#' hwe.jags          \tab      Hardy-Weinberg equlibrium test for a multiallelic marker using JAGS\cr
#' invnormal         \tab      inverse Normal transformation\cr
#' kin.morgan        \tab      kinship matrix for simple pedigree\cr
#' LD22              \tab      LD statistics for two diallelic markers\cr
#' LDkl              \tab      LD statistics for two multiallelic markers\cr
#' lambda1000        \tab      A standardized estimate of the genomic inflation scaling to\cr
#'                   \tab      a study of 1,000 cases and 1,000 controls\cr
#' log10p            \tab      log10(p) for a standard normal deviate\cr
#' log10pvalue       \tab      log10(p) for a P value including its scientific format\cr
#' logp              \tab      log(p) for a normal deviate\cr
#' masize            \tab      Sample size calculation for mediation analysis\cr
#' MCMCgrm           \tab	    Mixed modeling with genetic relationship matrices\cr
#' mia               \tab      multiple imputation analysis for hap\cr
#' mr                \tab      Mendelian randomization analysis\cr
#' mtdt              \tab      Transmission/disequilibrium test of a multiallelic marker\cr
#' mtdt2             \tab      Transmission/disequilibrium test of a multiallelic marker\cr
#'                   \tab      by Bradley-Terry model\cr
#' mvmeta            \tab      Multivariate meta-analysis based on generalized least squares\cr
#' pbsize            \tab      Power for population-based association design\cr
#' pbsize2           \tab      Power for case-control association design\cr
#' pfc               \tab      Probability of familial clustering of disease\cr
#' pfc.sim           \tab      Probability of familial clustering of disease\cr
#' pgc               \tab      Preparing weight for GENECOUNTING\cr
#' print.hap.score   \tab      Print a hap.score object\cr
#' s2k               \tab      Statistics for 2 by K table\cr
#' sentinels         \tab      Sentinel identification from GWAS summary statistics\cr
#' tscc              \tab      Power calculation for two-stage case-control design\cr
#' \cr
#' \strong{GRAPHICS}\cr
#' \cr
#' asplot            \tab      Regional association plot\cr
#' ESplot            \tab      Effect-size plot\cr
#' circos.cis.vs.trans.plot \tab circos plot of cis/trans classification\cr
#' circos.cnvplot    \tab      circos plot of CNVs\cr
#' circos.mhtplot    \tab      circos Manhattan plot with gene annotation\cr
#' circos.mhtplot2   \tab      Another circos Manhattan plot\cr
#' cnvplot           \tab      genomewide plot of CNVs\cr
#' labelManhattan    \tab      Annotate Manhattan or Miami Plot\cr
#' makeRLEplot       \tab      make relative log expression plot\cr
#' METAL_forestplot  \tab      forest plot as R/meta's forest for METAL outputs\cr
#' mhtplot           \tab      Manhattan plot\cr
#' mhtplot2          \tab      Manhattan plot with annotations\cr
#' mhtplot.trunc     \tab      truncated Manhattan plot\cr
#' miamiplot         \tab      Miami plot\cr
#' miamiplot2        \tab      Miami plot\cr
#' mr_forestplot     \tab      Mendelian Randomization forest plot\cr
#' pedtodot          \tab      Converting pedigree(s) to dot file(s)\cr
#' pedtodot_verbatim \tab      Pedigree-drawing with graphviz\cr
#' plot.hap.score    \tab      Plot haplotype frequencies versus haplotype score statistics\cr
#' qqfun             \tab      Quantile-comparison plots\cr
#' qqunif            \tab      Q-Q plot for uniformly distributed random variable\cr
#' qtl2dplot         \tab      2D QTL plot\cr
#' qtl2dplotly       \tab      2D QTL plotly\cr
#' qtl3dplotly       \tab      3D QTL plotly\cr
#' \cr
#' \strong{UTITLITIES}\cr
#' \cr
#' SNP               \tab      Functions for single nucleotide polymorphisms (SNPs)\cr
#' BFDP              \tab      Bayesian false-discovery probability\cr
#' FPRP              \tab      False-positive report probability\cr
#' ab                \tab      Test/Power calculation for mediating effect\cr
#' b2r               \tab      Obtain correlation coefficients and their variance-covariances\cr
#' chow.test         \tab      Chow's test for heterogeneity in two regressions\cr
#' chr_pos_a1_a2     \tab      Form SNPID from chromosome, posistion and alleles\cr
#' ci2ms             \tab      Effect size and standard error from confidence interval\cr
#' cis.vs.trans.classification \tab a cis/trans classifier\cr
#' comp.score        \tab      score statistics for testing genetic linkage of quantitative trait\cr
#' GRM functions     \tab      ReadGRM, ReadGRMBin, ReadGRMPLINK, ReadGRMPCA, WriteGRM,\cr
#'                   \tab      WriteGRMBin, WriteGRMSAS\cr
#'                   \tab      handle genomic relationship matrix involving other software\cr
#' get_b_se          \tab      Get b and se from AF, n, and z\cr
#' get_pve_se        \tab      Get pve and its standard error from n, z\cr
#' get_sdy           \tab      Get sd(y) from AF, n, b, se\cr
#' h2G               \tab      A utility function for heritability\cr
#' h2GE              \tab      A utility function for heritability involving gene-environment interaction\cr
#' h2l               \tab      A utility function for converting observed heritability to its counterpart\cr
#'                   \tab      under liability threshold model\cr
#' h2_mzdz           \tab      Heritability estimation according to twin correlations\cr
#' klem              \tab      Haplotype frequency estimation based on a genotype table\cr
#'                   \tab      of two multiallelic markers\cr
#' makeped           \tab      A function to prepare pedigrees in post-MAKEPED format\cr
#' metap             \tab      Meta-analysis of p values\cr
#' metareg           \tab      Fixed and random effects model for meta-analysis\cr
#' muvar             \tab      Means and variances under 1- and 2- locus (diallelic) QTL model\cr
#' qtlClassifier     \tab      A QTL cis/trans classifier\cr
#' read.ms.output    \tab      A utility function to read ms output\cr
#' revStrand         \tab      Allele on the reverse strand\cr
#' runshinygap       \tab      Start shinygap\cr
#' snptest_sample    \tab      A utility to generate SNPTEST sample file\cr
#' whscore           \tab      Whittemore-Halpern scores for allele-sharing\cr
#' weighted.median   \tab      Weighted median with interpolation\cr
#' \cr
#' }
#'
#' @section Usage:
#' Vignettes on package usage:
#' - Genetic Analysis Package. `vignette("gap")`.
#' - Shiny for Genetic Analysis Package (gap) Designs. `vignette("shinygap")`.
#' - JSS paper: Genetic Analysis Package. `vignette("jss")`.
#'
#' @docType package
#' @name gap
#' @aliases gap-package
#'
#' @import dplyr gap.datasets
#' @importFrom grDevices dev.off palette pdf xy.coords
#' @importFrom graphics abline arrows axis box boxplot
#'             identify legend lines mtext par points
#'             segments text title
#' @importFrom stats as.formula coef coefficients cor
#'             complete.cases dnorm glm integrate lm median
#'             nlm pchisq pf pnorm ppoints pt qchisq qnorm
#'             qqplot qt quantile rbinom rexp rnorm
#'             runif sd setNames var
#' @importFrom utils data head packageDescription read.csv
#'             read.delim read.table tail write.table
#'             globalVariables
#' @importFrom Rdpack reprompt
#' @useDynLib gap
#'
#' @author Jing Hua Zhao in collaboration with other colleagues and with
#'         help from Kurt Hornik, Brian Ripley, Uwe Ligges and Achim Zeileis
#'
#' maitained by Jing Hua Zhao <jinghuazhao@hotmail.com>
#'
#' @references
#' \insertRef{zhao07}{gap}
#'
#' @keywords internal

"_PACKAGE"
