% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.cv.fwelnet.R
\name{plot.cv.fwelnet}
\alias{plot.cv.fwelnet}
\title{Plot the cross-validation curve produced by "cv.fwelnet" object}
\usage{
\method{plot}{cv.fwelnet}(x, sign.lambda = 1, ...)
}
\arguments{
\item{x}{Fitted "\code{cv.fwelnet}" object.}

\item{sign.lambda}{Either plot against \code{log(lambda)} (default) or
\code{-log(lambda)} (if \code{sign.lambda = -1}).}

\item{...}{Other graphical paramters to plot.}
}
\description{
Plots the cross-validation curve produced by a \code{cv.fwelnet} object, along
with upper and lower standard deviation curves, as a function of the \code{lambda}
values used.
}
\details{
A plot is produced and nothing is returned.
}
\examples{
set.seed(1)
n <- 100; p <- 20
x <- matrix(rnorm(n * p), n, p)
beta <- matrix(c(rep(2, 5), rep(0, 15)), ncol = 1)
y <- x \%*\% beta + rnorm(n)
z <- cbind(1, abs(beta) + rnorm(p))

cvfit <- cv.fwelnet(x, y, z)
plot(cvfit)

# plot flipped: x-axis tracks -log(lambda) instead
plot(cvfit, sign.lambda = -1)

}
\seealso{
\code{\link{fwelnet}} and \code{\link{cv.fwelnet}}.
}
