% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean_fusen_files.R
\name{check_not_registered_files}
\alias{check_not_registered_files}
\title{Show in a table files that are not already registered in the yaml config file}
\usage{
check_not_registered_files(path = ".", guess = TRUE, to_csv = TRUE)
}
\arguments{
\item{path}{Path to package to check for not registered files}

\item{guess}{Logical. Guess if the file was inflated by a specific flat file}

\item{to_csv}{Logical. Whether to store along the config file, the outputs in a csv for the user to clean it manually}
}
\value{
Path to csv file if \code{to_csv} is TRUE. \code{dput()} of the dataframe otherwise.
}
\description{
If user start their package without 'fusen' or with version < 0.4, they need to create the config file, with already existing functions.
}
\examples{
\dontrun{
# Run this on the current package in development
out_csv <- check_not_registered_files()
out_csv
}

# Or you can try on the reproducible example
dummypackage <- tempfile("clean")
dir.create(dummypackage)

# {fusen} steps
fill_description(pkg = dummypackage, fields = list(Title = "Dummy Package"))
dev_file <- suppressMessages(add_flat_template(pkg = dummypackage, overwrite = TRUE, open = FALSE))
flat_file <- dev_file[grepl("flat_", dev_file)]
# Inflate once
usethis::with_project(dummypackage, {
  suppressMessages(
    inflate(
      pkg = dummypackage, flat_file = flat_file,
      vignette_name = "Get started", check = FALSE,
      open_vignette = FALSE
    )
  )

  # Add a not registered file to the package
  cat("# test R file", file = file.path(dummypackage, "R", "to_keep.R"))

  # Use the fonction to check the list of files
  out_csv <- check_not_registered_files(dummypackage)
  out_csv
  # Open the csv to modify manually the list of files in the csv created
  # Indeed, the "to_keep.R" file will be registered as
  # "No existing source path found."
  # Manually change this line with "keep"
  content_csv <- read.csv(out_csv, stringsAsFactors = FALSE)
  # Here I change the line to simulate what you manually did above
  content_csv[content_csv[["path"]] == "R/to_keep.R", "origin"] <- "keep"
  write.csv(content_csv, out_csv)

  out_config <- df_to_config(df_files = out_csv)
  out_config
  # Open the out_config file to see what's going on
  yaml::read_yaml(out_config)
})
unlink(dummypackage, recursive = TRUE)
}
