% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{spa_get_type}
\alias{spa_get_type}
\title{Get the type of a spatial plateau object}
\usage{
spa_get_type(pgo)
}
\arguments{
\item{pgo}{A \code{pgeometry} object of any type.}
}
\value{
The type of a spatial plateau object as a character object (i.e., a string).
}
\description{
\code{spa_get_type()} returns the type of a spatial plateau object.
It can be either \code{"PLATEAUPOINT"}, \code{"PLATEAULINE"}, \code{"PLATEAUREGION"}, \code{"PLATEAUCOMPOSITION"}, or \code{"PLATEAUCOLLECTION"}.
}
\details{
The \code{spa_get_type()} function yields the type of a spatial plateau object given as input.
For instance, if the \code{pgo} is a object of the class \code{ppoint} (subclass of \code{pgeometry}), it returns \code{"PLATEAUPOINT"}.
}
\examples{
pcomp1 <- create_component("MULTIPOINT(1 2, 3 2)", 0.4)
pcomp2 <- create_component("POINT(2 1)", 0.3)
ppoint <- create_pgeometry(list(pcomp1, pcomp2), "PLATEAUPOINT")

spa_get_type(ppoint) 

lcomp1 <- create_component("LINESTRING(1 2, 3 3, 3 4)", 1)
lcomp2 <- create_component("LINESTRING(0 0, 5 5)", 0.5)
pline <- create_pgeometry(list(lcomp1, lcomp2), "PLATEAULINE")

spa_get_type(pline)

pcomposition <- create_pgeometry(list(ppoint, pline), "PLATEAUCOMPOSITION")

spa_get_type(pcomposition)
}
