% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars-bootstrap.R
\name{bs_vars_wells}
\alias{bs_vars_wells}
\title{Bootstrap wells variables}
\usage{
bs_vars_wells(bg = NULL, border = NULL)
}
\arguments{
\item{bg}{Background color (default in Shiny is gray).}

\item{border}{Border color.}
}
\value{
a \code{list} that can be used in \code{\link{create_theme}}.
}
\description{
Those variables can be used to customize
 wells panel (e.g. \code{\link[shiny:wellPanel]{shiny::wellPanel}} or
 \code{\link[shiny:sidebarLayout]{shiny::sidebarPanel}}) in Bootstrap and Bootswatch themes.
}
\note{
See default parameters for Bootstrap: \url{https://getbootstrap.com/docs/3.4/customize/}.
}
\examples{
# Background color of wellPanel
bs_vars_wells(
  bg = "#CEECF5"
)


if (interactive()) {
  library(shiny)

  ui <- fluidPage(
    use_theme(create_theme(
      theme = "default",
      bs_vars_wells(
        bg = "#CEECF5"
      )
    )),
    wellPanel(
      "This is a wellPanel"
    )
  )

  server <- function(input, output, session) {

  }

  shinyApp(ui, server)
}
}
