% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{setFplot_distr}
\alias{setFplot_distr}
\alias{getFplot_distr}
\title{Sets the defaults of plot_distr}
\usage{
setFplot_distr(
  sorted,
  log,
  top,
  yaxis.num,
  col,
  border = "black",
  mod.method,
  within,
  total,
  at_5,
  labels.tilted,
  other,
  cumul = FALSE,
  centered = TRUE,
  weight.fun,
  int.categorical,
  dict = NULL,
  mod.title = TRUE,
  labels.angle,
  cex.axis,
  trunc = 20,
  trunc.method = "auto",
  reset = FALSE
)

getFplot_distr()
}
\arguments{
\item{sorted}{Logical: should the first elements displayed be the most frequent?
By default this is the case except for numeric values put to log or to integers.}

\item{log}{Logical, only used when the data is numeric. If \code{TRUE}, then
the data is put to logarithm beforehand. By default numeric values are put to
log if the log variation exceeds 3.}

\item{top}{What to display on the top of the bars. Can be equal to "frac" (for
shares), "nb" or "none". The default depends on the type of the plot. To disable
it you can also set it to \code{FALSE} or the empty string.}

\item{yaxis.num}{Whether the y-axis should display regular numbers instead of
frequencies in percentage points. By default it shows numbers only when the data
is weighted with a different function than the sum. For conditionnal distributions,
a numeric y-axis can be displayed only when \code{mod.method = "sideTotal"},
\code{mod.method = "splitTotal"} or \code{mod.method = "stack"}, since for the
within distributions it does not make sense (because the data is rescaled for each moderator).}

\item{col}{A vector of colors, default is close to paired. You can also use \dQuote{set1}
or \dQuote{paired}.}

\item{border}{Outer color of the bars. Defaults is \code{"black"}. Use \code{NA}
to remove the borders.}

\item{mod.method}{A character scalar: either i) \dQuote{split}, the default for
categorical data, ii) \dQuote{side}, the default for data in logarithmic form
or numeric data, or iii) \dQuote{stack}. This is only used when there is more
ù than one moderator. If \code{"split"}: there is one separate histogram for each
moderator case. If \code{"side"}: moderators are represented side by side for
each value of the variable. If \code{"stack"}: the bars of the moderators are
stacked onto each other, the bar heights representing the distribution in the
total population. You can use the other arguments \code{within} and \code{total}
to say whether the distributions should be within each moderator or over the
total distribution.}

\item{within}{Logical, default is missing. Whether the distributions should be
scaled to reflect the distribution within each moderator value. By default it
is \code{TRUE} if \code{mod.method} is different from \code{"stack"}.}

\item{total}{Logical, default is missing. Whether the distributions should be
scaled to reflect the total distribution (and not the distribution within each
moderator value). By default it is \code{TRUE} only if \code{mod.method="stack"}.}

\item{at_5}{Equal to \code{FALSE}, \code{"roman"} or \code{"line"}. When plotting
categorical variables, adds a small Roman number under every 5 bars
(\code{at_5 = "roman"}), or draws a thick axis line every 5 bars (\code{at_5 = "line"}).
Helps to get the rank of the bars. The default depends on the type of data --
Not implemented when there is a moderator.}

\item{labels.tilted}{Whether there should be tilted labels. Default is \code{FALSE}
except when the data is split by moderators (see \code{mod.method}).}

\item{other}{Logical. Should there be a last column counting for the observations
not displayed? Default is \code{TRUE} except when the data is split.}

\item{cumul}{Logical, default is \code{FALSE}. If \code{TRUE}, then the cumulative
distribution is plotted.}

\item{centered}{Logical, default is \code{TRUE}. For numeric data only and when
\code{sorted=FALSE}, whether the histogram should be centered on the mode.}

\item{weight.fun}{A function, by default it is \code{sum}. Aggregate function
to be applied to the weight with respect to variable and the moderator. See examples.}

\item{int.categorical}{Logical. Whether integers should be treated as categorical
variables. By default they are treated as categorical only when their range is
small (i.e. smaller than 1000).}

\item{dict}{A dictionnary to rename the variables names in the axes and legend.
Should be a named vector. By default it s the value of \code{getFplot_dict()},
which you can set with the function \code{\link[fplot]{setFplot_dict}}.}

\item{mod.title}{Character scalar. The title of the legend in case there is a
moderator. You can set it to \code{TRUE} (the default) to display the moderator
name. To display no title, set it to \code{NULL} or \code{FALSE}.}

\item{labels.angle}{Only if the labels of the x-axis are tilted. The angle of the tilt.}

\item{cex.axis}{Cex value to be passed to biased labels. By defaults, it finds
automatically the right value.}

\item{trunc}{If the main variable is a character, its values are truncaded to
\code{trunc} characters. Default is 20. You can set the truncation method with
the argument \code{trunc.method}.}

\item{trunc.method}{If the elements of the x-axis need to be truncated, this
is the truncation method. It can be "auto", "right" or "mid".}

\item{reset}{Logical scalar, default is \code{FALSE}. Whether the defaults should be reset.}
}
\value{
The function \code{setFplot_distr()} does not return anything, it only sets the default
parameters for the function \code{\link[=plot_distr]{plot_distr()}}.

The function \code{getFplot_distr()} returns a named list containing the arguments
that have been set with the function \code{setFplot_distr()}.
}
\description{
The default values of most arguments of \code{\link[fplot]{plot_distr}} can be
set with \code{setFplot_distr}.
}
\examples{

# Changing the default color set for plot_distr only
my_col = c("#36688D", "#F3CD05", "#F49F05", "#F18904", "#BDA589")

setFplot_distr(col = my_col, mod.method = "split", border = NA)

plot_distr(~ Petal.Length | Species, iris)

# Back to normal
setFplot_distr(reset = TRUE)

plot_distr(~ Petal.Length | Species, iris)



}
\seealso{
\code{\link[fplot]{plot_distr}}, \code{\link[fplot]{pdf_fit}}, \code{\link[fplot]{fit.off}}.
}
