% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tostring.R
\name{wrap_string}
\alias{wrap_string}
\alias{wrap_txt}
\title{Wrap a string to within a maximum width}
\usage{
wrap_string(str, max_width, hard = FALSE)

wrap_txt(txt, max_width, hard = FALSE)
}
\arguments{
\item{str}{character(1). String to be wrapped}

\item{max_width}{numeric(1). Maximum width, in characters, that the
text should be wrapped at.}

\item{hard}{logical(1). Should hard wrapping (embedding newlines in
the incoming strings) or soft (breaking wrapped strings into vectors
of length >1) be used. Defaults to \code{FALSE} (i.e. soft wrapping).}

\item{txt}{character. Vector of strings that should be (independently)
text-wrapped.}
}
\value{
A string (\code{wrap_string} or character vector (\code{wrap_txt}) containing
the hard or soft word-wrapped content.
}
\description{
Wrap a string to within a maximum width
}
\details{
Word wrapping happens as with \link[base:strwrap]{base::strwrap}
with the following exception: individual words which are longer
than \code{max_width} are broken up in a way that fits with the rest of the
word wrapping.
}
