% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make-boxplot.R
\name{make_boxplot}
\alias{make_boxplot}
\title{Create horizontal boxplot grob}
\usage{
make_boxplot(
  est,
  lower,
  upper,
  lowhinge,
  uphinge,
  hinge_height = 0.2,
  pch,
  sizes = 1,
  gp = gpar(),
  gp_box = gp,
  t_height = NULL,
  xlim = c(0, 1),
  nudge_y = 0
)
}
\arguments{
\item{est}{Median value.}

\item{lower}{Lower whisker.}

\item{upper}{Upper whisker.}

\item{lowhinge}{Lower hinge, a standard whisker will be drawn if this
is missing.}

\item{uphinge}{Ppper hinge, a standard whisker will be drawn if this
is missing.}

\item{hinge_height}{Height of the hinge, default is 0.2.}

\item{pch}{Numeric or character vector indicating what sort of plotting
symbol to use. See \code{\link[grid]{pointsGrob}}.}

\item{sizes}{Size of the point estimation box, can be a unit, vector or a list.
Values will be used as it is, no transformation will be applied.}

\item{gp}{Graphical parameters of \code{\link[grid]{gpar}}. Please refer
to \code{\link{forest_theme}} for more details.}

\item{gp_box}{Graphical parameters passed to the hinge, this will be
passed to \code{\link[grid]{rectGrob}}. This does not support multiple groups.}

\item{t_height}{Height of the whisker end vertices. If value is \code{NULL} (default),
no vertices will be drawn.}

\item{xlim}{Limits for the x axis as a vector of length 2, i.e. c(low, high).}

\item{nudge_y}{Horizontal adjustment to nudge groups by, must be within 0 to 1.}
}
\value{
A gTree object
}
\description{
Create horizontal boxplot grob
}
\examples{
library(grid)

# Function to calculate Box plot values
box_func <- function(x){
  iqr <- IQR(x)
  q3 <- quantile(x, probs = c(0.25, 0.5, 0.75), names = FALSE)
  c("min" = q3[1] - 1.5*iqr, "q1" = q3[1], "med" = q3[2],
    "q3" = q3[3], "max" = q3[3] + 1.5*iqr)
}
# Prepare data
val <- split(ToothGrowth$len, list(ToothGrowth$supp, ToothGrowth$dose))
val <- lapply(val, box_func)

dat <- do.call(rbind, val)
dat <- data.frame(Dose = row.names(dat),
                  dat, row.names = NULL)

dat$Box <- paste(rep(" ", 20), collapse = " ")

# Draw single group box plot
tm <- forest_theme(ci_Theight = 0.2)

p <- forest(dat[,c(1, 7)],
            est = dat$med,
            lower = dat$min,
            upper = dat$max,
            # sizes = sizes,
            fn_ci = make_boxplot,
            ci_column = 2,
            lowhinge = dat$q1,
            uphinge = dat$q3,
            hinge_height = 0.2,
            index_args = c("lowhinge", "uphinge"),
            gp_box = gpar(fill = "black", alpha = 0.4),
            theme = tm
)
p

# Multiple group
# Prepare data
dat_oj <- dat[c(1, 3, 5),]
dat_vc <- dat[c(2, 4, 6), ]

dat <- data.frame(Dose = c(0.5, 1, 2))
dat$Box <- paste(rep(" ", 20), collapse = " ")

# Draw plot
tm <- forest_theme(ci_Theight = 0.2,
                   ci_pch = 3)

p <- forest(dat,
            est = list(dat_oj$med, dat_vc$med),
            lower = list(dat_oj$min, dat_vc$min),
            upper = list(dat_oj$max, dat_vc$max),
            fn_ci = make_boxplot,
            ci_column = 2,
            lowhinge = list(dat_oj$q1, dat_vc$q1),
            uphinge = list(dat_oj$q3, dat_vc$q3),
            hinge_height = 0.2,
            index_args = c("lowhinge", "uphinge"),
            theme = tm
)

p


}
\seealso{
\code{\link[grid]{pointsGrob}} \code{\link[grid]{gpar}} \code{\link[grid]{rectGrob}}
\code{\link[grid]{linesGrob}} \code{\link[grid]{segmentsGrob}}
}
