% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forestplot_helpers.R
\name{prGetShapeGp}
\alias{prGetShapeGp}
\title{A function to extract graphical parameters from a fpShapesGp object}
\usage{
prGetShapeGp(
  shapes_gp,
  coords,
  object,
  default = grid::gpar(),
  nodefault = FALSE
)
}
\arguments{
\item{shapes_gp}{An object of class \code{\link{fpShapesGp}} specifying all graphical parameters}

\item{coords}{A numeric vector of length 2, specifying the label number (first item of the vector)
and the confidence band number within this label ; that can be >= 2 if there are multiple confidence
bands per label. Can be NULL for objects that are used only once (e.g. axes).
Vector \code{coords} must have an R attribute \code{max.coords} as numeric vector of length 2
specifying the total number of labels
and number of confidence bands by label for the forest plot.
The first coordinate specify the label number and the second coordinate (for multi-band forest plots)
specifies the band number within the label.}

\item{object}{One of \code{"box"}, \code{"lines"}, \code{"vertices"}, \code{"summary"}, \code{"zero"},
\code{"axes"}, \code{"hrz_lines"} or \code{"grid"}, refering to the object for which the
graphical parameters are requested.}

\item{default}{Default attributes to rely on when neither found in \code{shapes_gp$object}
nor in \code{shapes_gp$default}}

\item{nodefault}{Logical. If TRUE, do not search attribute in shapes_gp$default}
}
\value{
An object of class \code{\link[grid]{gpar}}
}
\description{
A function to extract graphical parameters from a fpShapesGp object
}
\author{
Andre GILLIBERT
}
