% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim.R
\name{sim.var}
\alias{sim.var}
\title{Simulate a VAR(1) process}
\usage{
sim.var(n, p, Gamma = diag(1, p), heavy = FALSE)
}
\arguments{
\item{n}{sample size}

\item{p}{dimension}

\item{Gamma}{innovation covariance matrix; ignored if \code{heavy = TRUE}}

\item{heavy}{if \code{heavy = FALSE}, common shocks are generated from \code{rnorm} whereas if \code{heavy = TRUE}, from \code{rt} with \code{df = 5} and then scaled by \code{sqrt(3 / 5)}}
}
\value{
a list containing
\item{data}{ \code{ts} object with \code{n} rows and \code{p} columns }
\item{A}{ transition matrix}
\item{Gamma}{ innovation covariance matrix}
}
\description{
Simulate a VAR(1) process; see the reference for the generation of the transition matrix.
}
\examples{
idio <- sim.var(500, 50)
}
\references{
Barigozzi, M., Cho, H. & Owens, D. (2024+) FNETS: Factor-adjusted network estimation and forecasting for high-dimensional time series. Journal of Business & Economic Statistics (to appear).

Owens, D., Cho, H. & Barigozzi, M. (2024+) fnets: An R Package for Network Estimation and Forecasting via Factor-Adjusted VAR Modelling. The R Journal (to appear).
}
