% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Q.pred.R
\name{Q.pred}
\alias{Q.pred}
\title{Predict and plot the transition intensities}
\usage{
Q.pred(object, newdata, get.CI = TRUE,
       n.sim.CI = 1000, prob.lev = 0.05,
       plot.Q = FALSE, which.plots = NULL,
       cond.list.2d = NULL, plot.Q.2d = FALSE,
       rug = TRUE, ...)
}
\arguments{
\item{object}{Fitted model object.}

\item{newdata}{Dataframe containing the profile for which one wished to obtain the predicted transition intensities.}

\item{get.CI}{Whether to compute the confidence intervals.}

\item{n.sim.CI}{Number of simulations to be used for confidence intervals computation.}

\item{prob.lev}{Probability level of confidence intervals.}

\item{plot.Q}{Whether to output plots of transition intensities.}

\item{which.plots}{Number between 1 and the maximum number of non-null transition intensities. This can be used if only some plots are to be plotted.}

\item{cond.list.2d}{Value of covariate(s) to be kept fixed in the plotting of 3D-transition intensities.}

\item{plot.Q.2d}{Whether to plot 3D transition intensities (only valid if 2D-smooths are present).}

\item{rug}{Whether to include a rugplot of the observed transition times.}

\item{...}{Other graphical parameters.}
}
\value{
Estimated transition intensities (and confidence intervals).
\item{Q.hist}{List of predicted transition intensity matrices computed at each time point specified in \code{newdata}. This is a \code{nstates x nstates x n.pred} array, where \code{n.pred} is the number of rows in \code{newdata}.}
\item{Q.CI.lower}{Matrix containing the lower bounds of the confidence intervals for the predicted transition intensity matrix.}
\item{Q.CI.upper}{Matrix containing the upper bounds of the confidence intervals for the predicted transition intensity matrix.}
\item{full.X}{Full design matrix corresponding to the \code{newdata} provided.}
\item{Q.sim.hist}{List of transition intensity matrices simulated to obtain the confidence intervals at each time point from \code{newdata}. May be useful to quickly obtain intervals for a different confidence level.}
}
\description{
Function to predict and plot the estimated transition intensities (and confidence intervals).
}
\seealso{
\code{\link{fmsm}}
}
