% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flash_verbose_fns.R
\name{flash_verbose_max_chg_F}
\alias{flash_verbose_max_chg_F}
\title{Display the maximum difference in scaled factors}
\usage{
flash_verbose_max_chg_F(curr, prev, k)
}
\arguments{
\item{curr}{The \code{\link{flash_fit}} object from the current iteration.}

\item{prev}{The \code{\link{flash_fit}} object from the previous iteration.}

\item{k}{Only used during sequential backfits (that is, calls to
\code{\link{flash_backfit}} where \code{extrapolate = FALSE}). It then
takes the index of the factor/loadings pair currently being optimized.}
}
\value{
A character string, suitable for printing progress updates.
}
\description{
Displays the maximum (absolute) change over all (posterior expected values for)
  factors \eqn{f_{jk}}. At each iteration, the factors
  \eqn{f_{\cdot 1}, \ldots, f_{\cdot K}} are \eqn{L^2}-normalized.
}
\details{
This function is an example of a function that may be passed to
  parameter \code{fns} in function \code{\link{flash_set_verbose}} to
  customize the output that is printed after each greedy or backfitting
  iteration. See \code{\link{flash_set_verbose}} for details and examples.
}
\seealso{
\code{\link{flash_verbose_elbo}}, \code{\link{flash_verbose_elbo_diff}},
  \code{\link{flash_verbose_max_chg}}, \code{\link{flash_verbose_max_chg_L}}
}
