% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/etable.R
\name{extralines_register}
\alias{extralines_register}
\title{Register \code{extralines} macros to be used in \code{etable}}
\usage{
extralines_register(type, fun, alias)
}
\arguments{
\item{type}{A character scalar giving the type-name.}

\item{fun}{A function to be applied to a \code{fixest} estimation. It must return a scalar.}

\item{alias}{A character scalar. This is the alias to be used in lieu of the type name to form the row name.}
}
\description{
This function is used to create \code{extralines} (which is an argument of \code{\link{etable}}) macros that can be easily summoned in \code{\link{etable}}.
}
\details{
You can register as many macros as you wish, the only constraint is that the type name should not conflict with a \code{\link{fitstat}} type name.
}
\examples{


# We register a function computing the standard-deviation of the dependent variable
my_fun = function(x) sd(model.matrix(x, type = "lhs"))
extralines_register("sdy", my_fun, "SD(y)")

# An estimation
data(iris)
est = feols(Petal.Length ~ Sepal.Length | Species, iris)

# Now we can easily create a row with the SD of y.
# We just "summon" it in a one-sided formula
etable(est, extralines = ~ sdy)

# We can change the alias on the fly:
etable(est, extralines = list("_Standard deviation of the dep. var." = ~ sdy))




}
