% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodAF.R
\name{adaptivefence}
\alias{adaptivefence}
\title{Adaptive Fence model selection}
\usage{
adaptivefence(mf, f, ms, d, lf, pf, bs, grid = 101, bandwidth)
}
\arguments{
\item{mf}{function for fitting the model}

\item{f}{formula of full model}

\item{ms}{list of formula of candidates models}

\item{d}{data}

\item{lf}{measure lack of fit (to minimize)}

\item{pf}{model selection criteria, e.g., model dimension}

\item{bs}{bootstrap samples}

\item{grid}{grid for c}

\item{bandwidth}{bandwidth for kernel smooth function}
}
\value{
\item{models}{list all model candidates in the model space}
\item{B}{list the number of bootstrap samples that have been used}
\item{lack_of_fit_matrix}{list a matrix of Qs for all model candidates (in columns). Each row is for each bootstrap sample}
\item{Qd_matrix}{list a matrix of QM - QM.tilde for all model candidates. Each row is for each bootrap sample}
\item{bandwidth}{list the value of bandwidth}
\item{model_mat}{list a matrix of selected models at each c values in grid (in columns). Each row is for each bootstrap sample}
\item{freq_mat}{list a matrix of coverage probabilities (frequency/smooth_frequency) of each selected models for a given c value (index)}
\item{c}{list the adaptive choice of c value from which the parsimonious model is selected}
\item{sel_model}{list the selected (parsimonious) model given the adaptive c value}
}
\description{
Adaptive Fence model selection
}
\examples{
\dontrun{
require(fence)

#### Example 1 #####
data(iris)
full = Sepal.Length ~ Sepal.Width + Petal.Length + Petal.Width + (1|Species)
test_af = fence.lmer(full, iris)
plot(test_af)
test_af$sel_model

#### Example 2 #####
r =1234; set.seed(r)  
p=8; n=150; rho = 0.6
id = rep(1:50,each=3)
R = diag(p)
for(i in 1:p){
  for(j in 1:p){
     R[i,j] = rho^(abs(i-j))
  }
} 
R = 1*R
x=mvrnorm(n, rep(0, p), R)  # all x's are time-varying dependence #
colnames(x)=paste('x',1:p, sep='')
tbetas = c(0,0.5,1,0,0.5,1,0,0.5)  # non-zero beta 2,3,5,6,8
epsilon = rnorm(150)
y = x\%*\%tbetas + epsilon
colnames(y) = 'y'
data = data.frame(cbind(x,y,id))
full = y ~ x1+x2+x3+x4+x5+x6+x7+x8+(1|id)
#X = paste('x',1:p, sep='', collapse='+')
#full = as.formula(paste('y~',X,'+(1|id)', sep=""))  #same as previous one
fence_obj = fence.lmer(full,data)   # it takes 3-5 min #
plot(fence_obj)
fence_obj$sel_model
}
}
\references{
\itemize{
 \item{Jiang J., Rao J.S., Gu Z., Nguyen T. (2008),  Fence Methods for Mixed Model Selection. The Annals of Statistics, 36(4): 1669-1692}
 \item{Jiang J., Nguyen T., Rao J.S. (2009), A Simplified Adaptive Fence Procedure. Statistics and Probability Letters, 79, 625-629}
 \item{Thuan Nguyen, Jie Peng, Jiming Jiang (2014), Fence Methods for Backcross Experiments.  Statistical Computation and Simulation, 84(3), 644-662}
}
}
\author{
Jiming Jiang  Jianyang Zhao  J. Sunil Rao  Thuan Nguyen
}
