// Generated by rstantools.  Do not edit by hand.

/*
    fcirt is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    fcirt is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with fcirt.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_muppnocov_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_muppnocov");
    reader.add_event(124, 122, "end", "model_muppnocov");
    return reader;
}
#include <stan_meta_header.hpp>
class model_muppnocov
  : public stan::model::model_base_crtp<model_muppnocov> {
private:
        int n_student;
        int n_item;
        int n_pair;
        std::vector<std::vector<int> > res;
        int n_dimension;
        std::vector<std::vector<int> > p;
        std::vector<int> d;
        double ma;
        double va;
        double md;
        double vd;
        double mt;
        double vt;
public:
    model_muppnocov(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_muppnocov(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_muppnocov_namespace::model_muppnocov";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 6;
            context__.validate_dims("data initialization", "n_student", "int", context__.to_vec());
            n_student = int(0);
            vals_i__ = context__.vals_i("n_student");
            pos__ = 0;
            n_student = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_student", n_student, 1);
            current_statement_begin__ = 7;
            context__.validate_dims("data initialization", "n_item", "int", context__.to_vec());
            n_item = int(0);
            vals_i__ = context__.vals_i("n_item");
            pos__ = 0;
            n_item = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_item", n_item, 1);
            current_statement_begin__ = 8;
            context__.validate_dims("data initialization", "n_pair", "int", context__.to_vec());
            n_pair = int(0);
            vals_i__ = context__.vals_i("n_pair");
            pos__ = 0;
            n_pair = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_pair", n_pair, 1);
            current_statement_begin__ = 9;
            validate_non_negative_index("res", "n_student", n_student);
            validate_non_negative_index("res", "n_pair", n_pair);
            context__.validate_dims("data initialization", "res", "int", context__.to_vec(n_student,n_pair));
            res = std::vector<std::vector<int> >(n_student, std::vector<int>(n_pair, int(0)));
            vals_i__ = context__.vals_i("res");
            pos__ = 0;
            size_t res_k_0_max__ = n_student;
            size_t res_k_1_max__ = n_pair;
            for (size_t k_1__ = 0; k_1__ < res_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < res_k_0_max__; ++k_0__) {
                    res[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t res_i_0_max__ = n_student;
            size_t res_i_1_max__ = n_pair;
            for (size_t i_0__ = 0; i_0__ < res_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < res_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "res[i_0__][i_1__]", res[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 10;
            context__.validate_dims("data initialization", "n_dimension", "int", context__.to_vec());
            n_dimension = int(0);
            vals_i__ = context__.vals_i("n_dimension");
            pos__ = 0;
            n_dimension = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_dimension", n_dimension, 1);
            current_statement_begin__ = 11;
            validate_non_negative_index("p", "n_pair", n_pair);
            validate_non_negative_index("p", "2", 2);
            context__.validate_dims("data initialization", "p", "int", context__.to_vec(n_pair,2));
            p = std::vector<std::vector<int> >(n_pair, std::vector<int>(2, int(0)));
            vals_i__ = context__.vals_i("p");
            pos__ = 0;
            size_t p_k_0_max__ = n_pair;
            size_t p_k_1_max__ = 2;
            for (size_t k_1__ = 0; k_1__ < p_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < p_k_0_max__; ++k_0__) {
                    p[k_0__][k_1__] = vals_i__[pos__++];
                }
            }
            size_t p_i_0_max__ = n_pair;
            size_t p_i_1_max__ = 2;
            for (size_t i_0__ = 0; i_0__ < p_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < p_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "p[i_0__][i_1__]", p[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 12;
            validate_non_negative_index("d", "n_item", n_item);
            context__.validate_dims("data initialization", "d", "int", context__.to_vec(n_item));
            d = std::vector<int>(n_item, int(0));
            vals_i__ = context__.vals_i("d");
            pos__ = 0;
            size_t d_k_0_max__ = n_item;
            for (size_t k_0__ = 0; k_0__ < d_k_0_max__; ++k_0__) {
                d[k_0__] = vals_i__[pos__++];
            }
            size_t d_i_0_max__ = n_item;
            for (size_t i_0__ = 0; i_0__ < d_i_0_max__; ++i_0__) {
                check_greater_or_equal(function__, "d[i_0__]", d[i_0__], 0);
            }
            current_statement_begin__ = 15;
            context__.validate_dims("data initialization", "ma", "double", context__.to_vec());
            ma = double(0);
            vals_r__ = context__.vals_r("ma");
            pos__ = 0;
            ma = vals_r__[pos__++];
            current_statement_begin__ = 16;
            context__.validate_dims("data initialization", "va", "double", context__.to_vec());
            va = double(0);
            vals_r__ = context__.vals_r("va");
            pos__ = 0;
            va = vals_r__[pos__++];
            current_statement_begin__ = 17;
            context__.validate_dims("data initialization", "md", "double", context__.to_vec());
            md = double(0);
            vals_r__ = context__.vals_r("md");
            pos__ = 0;
            md = vals_r__[pos__++];
            current_statement_begin__ = 18;
            context__.validate_dims("data initialization", "vd", "double", context__.to_vec());
            vd = double(0);
            vals_r__ = context__.vals_r("vd");
            pos__ = 0;
            vd = vals_r__[pos__++];
            current_statement_begin__ = 19;
            context__.validate_dims("data initialization", "mt", "double", context__.to_vec());
            mt = double(0);
            vals_r__ = context__.vals_r("mt");
            pos__ = 0;
            mt = vals_r__[pos__++];
            current_statement_begin__ = 20;
            context__.validate_dims("data initialization", "vt", "double", context__.to_vec());
            vt = double(0);
            vals_r__ = context__.vals_r("vt");
            pos__ = 0;
            vt = vals_r__[pos__++];
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 26;
            validate_non_negative_index("theta", "n_student", n_student);
            validate_non_negative_index("theta", "n_dimension", n_dimension);
            num_params_r__ += (n_student * n_dimension);
            current_statement_begin__ = 27;
            validate_non_negative_index("a", "n_item", n_item);
            num_params_r__ += n_item;
            current_statement_begin__ = 28;
            validate_non_negative_index("b", "n_item", n_item);
            num_params_r__ += n_item;
            current_statement_begin__ = 29;
            validate_non_negative_index("t", "n_item", n_item);
            num_params_r__ += n_item;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_muppnocov() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        current_statement_begin__ = 26;
        if (!(context__.contains_r("theta")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable theta missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("theta");
        pos__ = 0U;
        validate_non_negative_index("theta", "n_student", n_student);
        validate_non_negative_index("theta", "n_dimension", n_dimension);
        context__.validate_dims("parameter initialization", "theta", "matrix_d", context__.to_vec(n_student,n_dimension));
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta(n_student, n_dimension);
        size_t theta_j_2_max__ = n_dimension;
        size_t theta_j_1_max__ = n_student;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                theta(j_1__, j_2__) = vals_r__[pos__++];
            }
        }
        try {
            writer__.matrix_unconstrain(theta);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable theta: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 27;
        if (!(context__.contains_r("a")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable a missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("a");
        pos__ = 0U;
        validate_non_negative_index("a", "n_item", n_item);
        context__.validate_dims("parameter initialization", "a", "vector_d", context__.to_vec(n_item));
        Eigen::Matrix<double, Eigen::Dynamic, 1> a(n_item);
        size_t a_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            a(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(0, 4, a);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable a: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 28;
        if (!(context__.contains_r("b")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable b missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("b");
        pos__ = 0U;
        validate_non_negative_index("b", "n_item", n_item);
        context__.validate_dims("parameter initialization", "b", "vector_d", context__.to_vec(n_item));
        Eigen::Matrix<double, Eigen::Dynamic, 1> b(n_item);
        size_t b_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
            b(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(5), 5, b);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable b: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        current_statement_begin__ = 29;
        if (!(context__.contains_r("t")))
            stan::lang::rethrow_located(std::runtime_error(std::string("Variable t missing")), current_statement_begin__, prog_reader__());
        vals_r__ = context__.vals_r("t");
        pos__ = 0U;
        validate_non_negative_index("t", "n_item", n_item);
        context__.validate_dims("parameter initialization", "t", "vector_d", context__.to_vec(n_item));
        Eigen::Matrix<double, Eigen::Dynamic, 1> t(n_item);
        size_t t_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < t_j_1_max__; ++j_1__) {
            t(j_1__) = vals_r__[pos__++];
        }
        try {
            writer__.vector_lub_unconstrain(-(5), 0, t);
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(std::runtime_error(std::string("Error transforming variable t: ") + e.what()), current_statement_begin__, prog_reader__());
        }
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            current_statement_begin__ = 26;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, Eigen::Dynamic> theta;
            (void) theta;  // dummy to suppress unused var warning
            if (jacobian__)
                theta = in__.matrix_constrain(n_student, n_dimension, lp__);
            else
                theta = in__.matrix_constrain(n_student, n_dimension);
            current_statement_begin__ = 27;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> a;
            (void) a;  // dummy to suppress unused var warning
            if (jacobian__)
                a = in__.vector_lub_constrain(0, 4, n_item, lp__);
            else
                a = in__.vector_lub_constrain(0, 4, n_item);
            current_statement_begin__ = 28;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> b;
            (void) b;  // dummy to suppress unused var warning
            if (jacobian__)
                b = in__.vector_lub_constrain(-(5), 5, n_item, lp__);
            else
                b = in__.vector_lub_constrain(-(5), 5, n_item);
            current_statement_begin__ = 29;
            Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> t;
            (void) t;  // dummy to suppress unused var warning
            if (jacobian__)
                t = in__.vector_lub_constrain(-(5), 0, n_item, lp__);
            else
                t = in__.vector_lub_constrain(-(5), 0, n_item);
            // model body
            {
            current_statement_begin__ = 41;
            validate_non_negative_index("response", "n_student", n_student);
            validate_non_negative_index("response", "n_pair", n_pair);
            std::vector<std::vector<local_scalar_t__  >  > response(n_student, std::vector<local_scalar_t__>(n_pair, local_scalar_t__(DUMMY_VAR__)));
            stan::math::initialize(response, DUMMY_VAR__);
            stan::math::fill(response, DUMMY_VAR__);
            current_statement_begin__ = 42;
            validate_non_negative_index("spr", "n_student", n_student);
            validate_non_negative_index("spr", "n_item", n_item);
            std::vector<std::vector<local_scalar_t__  >  > spr(n_student, std::vector<local_scalar_t__>(n_item, local_scalar_t__(DUMMY_VAR__)));
            stan::math::initialize(spr, DUMMY_VAR__);
            stan::math::fill(spr, DUMMY_VAR__);
            current_statement_begin__ = 45;
            lp_accum__.add(lognormal_log<propto__>(a, ma, va));
            current_statement_begin__ = 46;
            lp_accum__.add(normal_log<propto__>(b, md, vd));
            current_statement_begin__ = 47;
            lp_accum__.add(normal_log<propto__>(t, mt, vt));
            current_statement_begin__ = 63;
            for (int i = 1; i <= n_dimension; ++i) {
                current_statement_begin__ = 64;
                lp_accum__.add(normal_log<propto__>(stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_omni(), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "theta"), 0, 1));
            }
            current_statement_begin__ = 67;
            for (int i = 1; i <= n_student; ++i) {
                current_statement_begin__ = 68;
                for (int j = 1; j <= n_item; ++j) {
                    {
                    current_statement_begin__ = 69;
                    local_scalar_t__ thdim(DUMMY_VAR__);
                    (void) thdim;  // dummy to suppress unused var warning
                    stan::math::initialize(thdim, DUMMY_VAR__);
                    stan::math::fill(thdim, DUMMY_VAR__);
                    current_statement_begin__ = 70;
                    local_scalar_t__ num0(DUMMY_VAR__);
                    (void) num0;  // dummy to suppress unused var warning
                    stan::math::initialize(num0, DUMMY_VAR__);
                    stan::math::fill(num0, DUMMY_VAR__);
                    current_statement_begin__ = 71;
                    local_scalar_t__ num1(DUMMY_VAR__);
                    (void) num1;  // dummy to suppress unused var warning
                    stan::math::initialize(num1, DUMMY_VAR__);
                    stan::math::fill(num1, DUMMY_VAR__);
                    current_statement_begin__ = 72;
                    local_scalar_t__ denominator(DUMMY_VAR__);
                    (void) denominator;  // dummy to suppress unused var warning
                    stan::math::initialize(denominator, DUMMY_VAR__);
                    stan::math::fill(denominator, DUMMY_VAR__);
                    current_statement_begin__ = 75;
                    stan::math::assign(thdim, get_base1(theta, i, get_base1(d, j, "d", 1), "theta", 1));
                    current_statement_begin__ = 76;
                    stan::math::assign(num0, (1 + stan::math::exp((get_base1(a, j, "a", 1) * (3 * (thdim - get_base1(b, j, "b", 1)))))));
                    current_statement_begin__ = 77;
                    stan::math::assign(num1, (stan::math::exp((get_base1(a, j, "a", 1) * ((thdim - get_base1(b, j, "b", 1)) - get_base1(t, j, "t", 1)))) + stan::math::exp((get_base1(a, j, "a", 1) * ((2 * (thdim - get_base1(b, j, "b", 1))) - get_base1(t, j, "t", 1))))));
                    current_statement_begin__ = 78;
                    stan::math::assign(denominator, (num0 + num1));
                    current_statement_begin__ = 79;
                    stan::model::assign(spr, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                (num1 / denominator), 
                                "assigning variable spr");
                    }
                }
            }
            current_statement_begin__ = 85;
            for (int i = 1; i <= n_student; ++i) {
                current_statement_begin__ = 86;
                for (int j = 1; j <= n_pair; ++j) {
                    {
                    current_statement_begin__ = 87;
                    int s1(0);
                    (void) s1;  // dummy to suppress unused var warning
                    stan::math::fill(s1, std::numeric_limits<int>::min());
                    current_statement_begin__ = 88;
                    int t1(0);
                    (void) t1;  // dummy to suppress unused var warning
                    stan::math::fill(t1, std::numeric_limits<int>::min());
                    current_statement_begin__ = 89;
                    local_scalar_t__ pst(DUMMY_VAR__);
                    (void) pst;  // dummy to suppress unused var warning
                    stan::math::initialize(pst, DUMMY_VAR__);
                    stan::math::fill(pst, DUMMY_VAR__);
                    current_statement_begin__ = 90;
                    local_scalar_t__ pts(DUMMY_VAR__);
                    (void) pts;  // dummy to suppress unused var warning
                    stan::math::initialize(pts, DUMMY_VAR__);
                    stan::math::fill(pts, DUMMY_VAR__);
                    current_statement_begin__ = 95;
                    stan::math::assign(s1, get_base1(get_base1(p, j, "p", 1), 1, "p", 2));
                    current_statement_begin__ = 96;
                    stan::math::assign(t1, get_base1(get_base1(p, j, "p", 1), 2, "p", 2));
                    current_statement_begin__ = 98;
                    stan::math::assign(pst, (get_base1(get_base1(spr, i, "spr", 1), s1, "spr", 2) * (1 - get_base1(get_base1(spr, i, "spr", 1), t1, "spr", 2))));
                    current_statement_begin__ = 99;
                    stan::math::assign(pts, (get_base1(get_base1(spr, i, "spr", 1), t1, "spr", 2) * (1 - get_base1(get_base1(spr, i, "spr", 1), s1, "spr", 2))));
                    current_statement_begin__ = 102;
                    stan::model::assign(response, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::cons_list(stan::model::index_uni(j), stan::model::nil_index_list())), 
                                (pst / (pst + pts)), 
                                "assigning variable response");
                    }
                }
            }
            current_statement_begin__ = 116;
            lp_accum__.add(bernoulli_log<propto__>(to_array_1d(res), to_array_1d(response)));
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("theta");
        names__.push_back("a");
        names__.push_back("b");
        names__.push_back("t");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(n_student);
        dims__.push_back(n_dimension);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_item);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_item);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_item);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_muppnocov_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> theta = in__.matrix_constrain(n_student, n_dimension);
        size_t theta_j_2_max__ = n_dimension;
        size_t theta_j_1_max__ = n_student;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                vars__.push_back(theta(j_1__, j_2__));
            }
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> a = in__.vector_lub_constrain(0, 4, n_item);
        size_t a_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            vars__.push_back(a(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> b = in__.vector_lub_constrain(-(5), 5, n_item);
        size_t b_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
            vars__.push_back(b(j_1__));
        }
        Eigen::Matrix<double, Eigen::Dynamic, 1> t = in__.vector_lub_constrain(-(5), 0, n_item);
        size_t t_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < t_j_1_max__; ++j_1__) {
            vars__.push_back(t(j_1__));
        }
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_muppnocov";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t theta_j_2_max__ = n_dimension;
        size_t theta_j_1_max__ = n_student;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t a_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t b_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t t_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < t_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "t" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        size_t theta_j_2_max__ = n_dimension;
        size_t theta_j_1_max__ = n_student;
        for (size_t j_2__ = 0; j_2__ < theta_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < theta_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t a_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < a_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "a" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t b_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < b_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "b" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t t_j_1_max__ = n_item;
        for (size_t j_1__ = 0; j_1__ < t_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "t" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
    }
}; // model
}  // namespace
typedef model_muppnocov_namespace::model_muppnocov stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
