## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(collapse = TRUE, comment = "#>", eval = FALSE)
library(fastcpd)

## ----lasso_setup--------------------------------------------------------------
#  set.seed(1)
#  p_true <- 6
#  p <- 50
#  x <- mvtnorm::rmvnorm(480, rep(0, p), diag(p))
#  theta_0 <- rbind(
#    runif(p_true, -5, -2),
#    runif(p_true, -3, 3),
#    runif(p_true, 2, 5),
#    runif(p_true, -5, 5)
#  )
#  theta_0 <- cbind(theta_0, matrix(0, ncol = p - p_true, nrow = 4))
#  y <- c(
#    x[1:80, ] %*% theta_0[1, ] + rnorm(80, 0, 1),
#    x[81:200, ] %*% theta_0[2, ] + rnorm(120, 0, 1),
#    x[201:320, ] %*% theta_0[3, ] + rnorm(120, 0, 1),
#    x[321:480, ] %*% theta_0[4, ] + rnorm(160, 0, 1)
#  )

## ----lasso--------------------------------------------------------------------
#  result <- fastcpd(
#    formula = y ~ . - 1,
#    data = data.frame(y = y, x = x),
#    family = "lasso",
#    r.progress = FALSE
#  )
#  summary(result)
#  #>
#  #> Call:
#  #> fastcpd(formula = y ~ . - 1, data = data.frame(y = y, x = x),
#  #>     family = "lasso", r.progress = FALSE)
#  #>
#  #> Change points:
#  #> 79 199 317
#  #>
#  #> Cost values:
#  #> 125.1501 155.4486 160.4363 274.2228
#  #>
#  #> Parameters:
#  #> 50 x 4 sparse Matrix of class "dgCMatrix"
#  #>          segment 1    segment 2    segment 3    segment 4
#  #>  [1,] -2.580352409 -2.428039439  4.900559900 -2.749985232
#  #>  [2,] -2.668688731 -2.473539196  4.198921150  3.057387294
#  #>  [3,] -4.354248176  0.983488542  5.054325016  3.735347545
#  #>  [4,] -4.662566697  0.279505605  2.628354481 -3.216027015
#  #>  [5,] -4.820139326  0.496565230  4.611603593  3.231304715
#  #>  [6,] -3.860308911 -2.576467859  3.304903523  4.577405578
#  #>  [7,]  0.117234534 -0.219145186 -0.015091394 -0.086048806
#  #>  [8,]  0.117552281  0.035701649 -0.127986984 -0.138807479
#  #>  [9,] -0.188756652  0.133653604  0.038250526 -0.037807789
#  #> [10,] -0.074530965  0.010173561  0.021979969 -0.047707753
#  #> [11,] -0.061721013 -0.176769170 -0.059312332 -0.135633390
#  #> [12,]  0.021874954 -0.133777712  0.028889403 -0.130808437
#  #> [13,]  0.067777695  0.129187849 -0.026100120  0.002593292
#  #> [14,] -0.122270920  0.110865328  0.084858637  0.233903944
#  #> [15,] -0.014192027  0.086100909  0.030268607  0.243927135
#  #> [16,] -0.135970691 -0.043211895 -0.032229963 -0.134840827
#  #> [17,]  0.007608049 -0.079445537 -0.013675459  0.102010778
#  #> [18,] -0.010343806  0.132392790 -0.151237533 -0.123955960
#  #> [19,]  0.252797503  0.253113165 -0.197620792  0.099319824
#  #> [20,] -0.044505498 -0.049962311  0.233024977  0.176211754
#  #> [21,]  0.084292730  0.366833682 -0.220176991 -0.035984666
#  #> [22,] -0.373913824 -0.060767726  0.036430343 -0.105248408
#  #> [23,]  0.316816197 -0.191114879 -0.127549606 -0.112775343
#  #> [24,]  0.008174405  0.158066938 -0.121000263  0.232613924
#  #> [25,] -0.388590727  0.098542973 -0.045207238  0.003838229
#  #> [26,] -0.109916673  0.042028223  0.031122592 -0.173521656
#  #> [27,] -0.040845604  0.023057708  0.067839093  0.084198705
#  #> [28,]  0.080696347 -0.097192796  0.099373268 -0.166716428
#  #> [29,] -0.117530646  0.002589360  0.051425084  0.098244052
#  #> [30,] -0.037935138 -0.091390269  0.154099931  0.100237663
#  #> [31,]  0.109674339  0.158620750 -0.181802621 -0.112714822
#  #> [32,]  0.069971569 -0.425139230 -0.020032195 -0.193571920
#  #> [33,]  0.050674415  0.050518682 -0.010950361 -0.068936556
#  #> [34,]  0.065490413  0.142178491  0.174034864  0.072663828
#  #> [35,] -0.045676268 -0.057128729  0.050522160 -0.165689753
#  #> [36,]  0.368217440  0.096573493  0.120128008  0.020252183
#  #> [37,]  0.037286542 -0.056101952 -0.018563948  0.263830281
#  #> [38,]  0.094379823 -0.263914331 -0.002747609 -0.010850423
#  #> [39,]  0.153890231  0.071449851 -0.075881371 -0.060456457
#  #> [40,] -0.146742186 -0.117294226 -0.255229801 -0.124537184
#  #> [41,] -0.274840831  0.009051742  0.124862149  0.074433697
#  #> [42,] -0.008508998  0.110465493  0.215727137  0.269240087
#  #> [43,]  0.014213371 -0.041499271  0.097848087  0.105722611
#  #> [44,] -0.080890432  0.094198355  0.004240823 -0.187634605
#  #> [45,]  0.051925330 -0.007981636  0.044460236 -0.066537564
#  #> [46,]  0.213031014  0.168676929  0.097190703  0.046563300
#  #> [47,]  0.175716867  0.045500673  0.175902385 -0.030590597
#  #> [48,] -0.040155598 -0.120432098 -0.137764051 -0.088812037
#  #> [49,]  0.164103981  0.024976184  0.015955563 -0.232780151
#  #> [50,] -0.103164763 -0.135032022  0.029553283  0.267389634

## ----lasso_multiple_epochs_setup, include = FALSE-----------------------------
#  set.seed(1)
#  p_true <- 6
#  p <- 50
#  x <- mvtnorm::rmvnorm(480, rep(0, p), diag(p))
#  theta_0 <- rbind(
#    runif(p_true, -5, -2),
#    runif(p_true, -3, 3),
#    runif(p_true, 2, 5),
#    runif(p_true, -5, 5)
#  )
#  theta_0 <- cbind(theta_0, matrix(0, ncol = p - p_true, nrow = 4))
#  y <- c(
#    x[1:80, ] %*% theta_0[1, ] + rnorm(80, 0, 1),
#    x[81:200, ] %*% theta_0[2, ] + rnorm(120, 0, 1),
#    x[201:320, ] %*% theta_0[3, ] + rnorm(120, 0, 1),
#    x[321:480, ] %*% theta_0[4, ] + rnorm(160, 0, 1)
#  )

## ----lasso_multiple_epochs----------------------------------------------------
#  result_multiple_epochs <- fastcpd(
#    formula = y ~ . - 1,
#    data = data.frame(y = y, x = x),
#    family = "lasso",
#    multiple_epochs = function(segment_length) if (segment_length < 20) 1 else 0,
#    r.progress = FALSE
#  )
#  summary(result_multiple_epochs)
#  #>
#  #> Call:
#  #> fastcpd(formula = y ~ . - 1, data = data.frame(y = y, x = x),
#  #>     family = "lasso", multiple_epochs = function(segment_length) if (segment_length <
#  #>         20) 1 else 0, r.progress = FALSE)
#  #>
#  #> Change points:
#  #> 79 199 320
#  #>
#  #> Cost values:
#  #> 125.1501 155.4486 164.1284 177.9478
#  #>
#  #> Parameters:
#  #> 50 x 4 sparse Matrix of class "dgCMatrix"
#  #>          segment 1    segment 2    segment 3    segment 4
#  #>  [1,] -2.580352409 -2.428039439  4.898713954 -3.006202485
#  #>  [2,] -2.668688731 -2.473539196  4.209460633  3.096081968
#  #>  [3,] -4.354248176  0.983488542  5.011651466  3.718141515
#  #>  [4,] -4.662566697  0.279505605  2.623742216 -3.130632564
#  #>  [5,] -4.820139326  0.496565230  4.616444609  3.175562645
#  #>  [6,] -3.860308911 -2.576467859  3.336301862  4.342890940
#  #>  [7,]  0.117234534 -0.219145186 -0.039861426 -0.016395368
#  #>  [8,]  0.117552281  0.035701649 -0.075921029 -0.022022294
#  #>  [9,] -0.188756652  0.133653604  0.052907904  0.070683538
#  #> [10,] -0.074530965  0.010173561  0.003352400  0.012791767
#  #> [11,] -0.061721013 -0.176769170 -0.044814526 -0.166042077
#  #> [12,]  0.021874954 -0.133777712  0.103526247  0.077820866
#  #> [13,]  0.067777695  0.129187849 -0.072098209  0.077436979
#  #> [14,] -0.122270920  0.110865328  0.095306898  0.114046507
#  #> [15,] -0.014192027  0.086100909  0.006037145 -0.015966855
#  #> [16,] -0.135970691 -0.043211895  0.026749332 -0.095751983
#  #> [17,]  0.007608049 -0.079445537 -0.003130812 -0.010689927
#  #> [18,] -0.010343806  0.132392790 -0.156866781 -0.138057246
#  #> [19,]  0.252797503  0.253113165 -0.167436237  0.158967697
#  #> [20,] -0.044505498 -0.049962311  0.177560915  0.030169316
#  #> [21,]  0.084292730  0.366833682 -0.224849869 -0.181503446
#  #> [22,] -0.373913824 -0.060767726  0.003860114  0.045649997
#  #> [23,]  0.316816197 -0.191114879 -0.118941359 -0.025305755
#  #> [24,]  0.008174405  0.158066938 -0.135680402 -0.137396624
#  #> [25,] -0.388590727  0.098542973 -0.064383316  0.022336212
#  #> [26,] -0.109916673  0.042028223  0.017815134 -0.059782090
#  #> [27,] -0.040845604  0.023057708  0.053296378  0.030431412
#  #> [28,]  0.080696347 -0.097192796  0.122665492 -0.080706668
#  #> [29,] -0.117530646  0.002589360  0.062791240 -0.051542901
#  #> [30,] -0.037935138 -0.091390269  0.122976438  0.048892128
#  #> [31,]  0.109674339  0.158620750 -0.181785506  0.075434045
#  #> [32,]  0.069971569 -0.425139230  0.030472706  0.033375101
#  #> [33,]  0.050674415  0.050518682  0.034305534  0.070983107
#  #> [34,]  0.065490413  0.142178491  0.164899160  0.032575571
#  #> [35,] -0.045676268 -0.057128729  0.022794426 -0.134534869
#  #> [36,]  0.368217440  0.096573493  0.114099285 -0.020673038
#  #> [37,]  0.037286542 -0.056101952 -0.023029273  0.102043216
#  #> [38,]  0.094379823 -0.263914331  0.003288922 -0.052763017
#  #> [39,]  0.153890231  0.071449851 -0.097509620 -0.120642848
#  #> [40,] -0.146742186 -0.117294226 -0.208865036 -0.045775725
#  #> [41,] -0.274840831  0.009051742  0.127312770  0.123910218
#  #> [42,] -0.008508998  0.110465493  0.118453225 -0.005505113
#  #> [43,]  0.014213371 -0.041499271  0.113699538 -0.056131976
#  #> [44,] -0.080890432  0.094198355  0.051912519  0.013524984
#  #> [45,]  0.051925330 -0.007981636  0.085966205 -0.033628617
#  #> [46,]  0.213031014  0.168676929  0.035738422 -0.029655833
#  #> [47,]  0.175716867  0.045500673  0.175504506  0.119507574
#  #> [48,] -0.040155598 -0.120432098 -0.139162874 -0.054349982
#  #> [49,]  0.164103981  0.024976184  0.029374949 -0.056092814
#  #> [50,] -0.103164763 -0.135032022  0.047475507 -0.032491294

## ----lasso_vanilla_percentage_setup, include = FALSE--------------------------
#  set.seed(1)
#  p_true <- 6
#  p <- 50
#  x <- mvtnorm::rmvnorm(480, rep(0, p), diag(p))
#  theta_0 <- rbind(
#    runif(p_true, -5, -2),
#    runif(p_true, -3, 3),
#    runif(p_true, 2, 5),
#    runif(p_true, -5, 5)
#  )
#  theta_0 <- cbind(theta_0, matrix(0, ncol = p - p_true, nrow = 4))
#  y <- c(
#    x[1:80, ] %*% theta_0[1, ] + rnorm(80, 0, 1),
#    x[81:200, ] %*% theta_0[2, ] + rnorm(120, 0, 1),
#    x[201:320, ] %*% theta_0[3, ] + rnorm(120, 0, 1),
#    x[321:480, ] %*% theta_0[4, ] + rnorm(160, 0, 1)
#  )

## ----lasso_vanilla_percentage-------------------------------------------------
#  result_vanilla_percentage <- fastcpd(
#    formula = y ~ . - 1,
#    data = data.frame(y = y, x = x),
#    family = "lasso",
#    vanilla_percentage = 0.2,
#    r.progress = FALSE
#  )
#  summary(result_vanilla_percentage)
#  #>
#  #> Call:
#  #> fastcpd(formula = y ~ . - 1, data = data.frame(y = y, x = x),
#  #>     family = "lasso", vanilla_percentage = 0.2, r.progress = FALSE)
#  #>
#  #> Change points:
#  #> 79 199 317
#  #>
#  #> Cost values:
#  #> 125.1501 155.4486 160.4363 274.2228
#  #>
#  #> Parameters:
#  #> 50 x 4 sparse Matrix of class "dgCMatrix"
#  #>          segment 1    segment 2    segment 3    segment 4
#  #>  [1,] -2.580352409 -2.428039439  4.900559900 -2.749985232
#  #>  [2,] -2.668688731 -2.473539196  4.198921150  3.057387294
#  #>  [3,] -4.354248176  0.983488542  5.054325016  3.735347545
#  #>  [4,] -4.662566697  0.279505605  2.628354481 -3.216027015
#  #>  [5,] -4.820139326  0.496565230  4.611603593  3.231304715
#  #>  [6,] -3.860308911 -2.576467859  3.304903523  4.577405578
#  #>  [7,]  0.117234534 -0.219145186 -0.015091394 -0.086048806
#  #>  [8,]  0.117552281  0.035701649 -0.127986984 -0.138807479
#  #>  [9,] -0.188756652  0.133653604  0.038250526 -0.037807789
#  #> [10,] -0.074530965  0.010173561  0.021979969 -0.047707753
#  #> [11,] -0.061721013 -0.176769170 -0.059312332 -0.135633390
#  #> [12,]  0.021874954 -0.133777712  0.028889403 -0.130808437
#  #> [13,]  0.067777695  0.129187849 -0.026100120  0.002593292
#  #> [14,] -0.122270920  0.110865328  0.084858637  0.233903944
#  #> [15,] -0.014192027  0.086100909  0.030268607  0.243927135
#  #> [16,] -0.135970691 -0.043211895 -0.032229963 -0.134840827
#  #> [17,]  0.007608049 -0.079445537 -0.013675459  0.102010778
#  #> [18,] -0.010343806  0.132392790 -0.151237533 -0.123955960
#  #> [19,]  0.252797503  0.253113165 -0.197620792  0.099319824
#  #> [20,] -0.044505498 -0.049962311  0.233024977  0.176211754
#  #> [21,]  0.084292730  0.366833682 -0.220176991 -0.035984666
#  #> [22,] -0.373913824 -0.060767726  0.036430343 -0.105248408
#  #> [23,]  0.316816197 -0.191114879 -0.127549606 -0.112775343
#  #> [24,]  0.008174405  0.158066938 -0.121000263  0.232613924
#  #> [25,] -0.388590727  0.098542973 -0.045207238  0.003838229
#  #> [26,] -0.109916673  0.042028223  0.031122592 -0.173521656
#  #> [27,] -0.040845604  0.023057708  0.067839093  0.084198705
#  #> [28,]  0.080696347 -0.097192796  0.099373268 -0.166716428
#  #> [29,] -0.117530646  0.002589360  0.051425084  0.098244052
#  #> [30,] -0.037935138 -0.091390269  0.154099931  0.100237663
#  #> [31,]  0.109674339  0.158620750 -0.181802621 -0.112714822
#  #> [32,]  0.069971569 -0.425139230 -0.020032195 -0.193571920
#  #> [33,]  0.050674415  0.050518682 -0.010950361 -0.068936556
#  #> [34,]  0.065490413  0.142178491  0.174034864  0.072663828
#  #> [35,] -0.045676268 -0.057128729  0.050522160 -0.165689753
#  #> [36,]  0.368217440  0.096573493  0.120128008  0.020252183
#  #> [37,]  0.037286542 -0.056101952 -0.018563948  0.263830281
#  #> [38,]  0.094379823 -0.263914331 -0.002747609 -0.010850423
#  #> [39,]  0.153890231  0.071449851 -0.075881371 -0.060456457
#  #> [40,] -0.146742186 -0.117294226 -0.255229801 -0.124537184
#  #> [41,] -0.274840831  0.009051742  0.124862149  0.074433697
#  #> [42,] -0.008508998  0.110465493  0.215727137  0.269240087
#  #> [43,]  0.014213371 -0.041499271  0.097848087  0.105722611
#  #> [44,] -0.080890432  0.094198355  0.004240823 -0.187634605
#  #> [45,]  0.051925330 -0.007981636  0.044460236 -0.066537564
#  #> [46,]  0.213031014  0.168676929  0.097190703  0.046563300
#  #> [47,]  0.175716867  0.045500673  0.175902385 -0.030590597
#  #> [48,] -0.040155598 -0.120432098 -0.137764051 -0.088812037
#  #> [49,]  0.164103981  0.024976184  0.015955563 -0.232780151
#  #> [50,] -0.103164763 -0.135032022  0.029553283  0.267389634

## ----ref.label = knitr::all_labels(), echo = TRUE, eval = FALSE---------------
#  knitr::opts_chunk$set(collapse = TRUE, comment = "#>", eval = FALSE)
#  library(fastcpd)
#  set.seed(1)
#  p_true <- 6
#  p <- 50
#  x <- mvtnorm::rmvnorm(480, rep(0, p), diag(p))
#  theta_0 <- rbind(
#    runif(p_true, -5, -2),
#    runif(p_true, -3, 3),
#    runif(p_true, 2, 5),
#    runif(p_true, -5, 5)
#  )
#  theta_0 <- cbind(theta_0, matrix(0, ncol = p - p_true, nrow = 4))
#  y <- c(
#    x[1:80, ] %*% theta_0[1, ] + rnorm(80, 0, 1),
#    x[81:200, ] %*% theta_0[2, ] + rnorm(120, 0, 1),
#    x[201:320, ] %*% theta_0[3, ] + rnorm(120, 0, 1),
#    x[321:480, ] %*% theta_0[4, ] + rnorm(160, 0, 1)
#  )
#  result <- fastcpd(
#    formula = y ~ . - 1,
#    data = data.frame(y = y, x = x),
#    family = "lasso",
#    r.progress = FALSE
#  )
#  summary(result)
#  #>
#  #> Call:
#  #> fastcpd(formula = y ~ . - 1, data = data.frame(y = y, x = x),
#  #>     family = "lasso", r.progress = FALSE)
#  #>
#  #> Change points:
#  #> 79 199 317
#  #>
#  #> Cost values:
#  #> 125.1501 155.4486 160.4363 274.2228
#  #>
#  #> Parameters:
#  #> 50 x 4 sparse Matrix of class "dgCMatrix"
#  #>          segment 1    segment 2    segment 3    segment 4
#  #>  [1,] -2.580352409 -2.428039439  4.900559900 -2.749985232
#  #>  [2,] -2.668688731 -2.473539196  4.198921150  3.057387294
#  #>  [3,] -4.354248176  0.983488542  5.054325016  3.735347545
#  #>  [4,] -4.662566697  0.279505605  2.628354481 -3.216027015
#  #>  [5,] -4.820139326  0.496565230  4.611603593  3.231304715
#  #>  [6,] -3.860308911 -2.576467859  3.304903523  4.577405578
#  #>  [7,]  0.117234534 -0.219145186 -0.015091394 -0.086048806
#  #>  [8,]  0.117552281  0.035701649 -0.127986984 -0.138807479
#  #>  [9,] -0.188756652  0.133653604  0.038250526 -0.037807789
#  #> [10,] -0.074530965  0.010173561  0.021979969 -0.047707753
#  #> [11,] -0.061721013 -0.176769170 -0.059312332 -0.135633390
#  #> [12,]  0.021874954 -0.133777712  0.028889403 -0.130808437
#  #> [13,]  0.067777695  0.129187849 -0.026100120  0.002593292
#  #> [14,] -0.122270920  0.110865328  0.084858637  0.233903944
#  #> [15,] -0.014192027  0.086100909  0.030268607  0.243927135
#  #> [16,] -0.135970691 -0.043211895 -0.032229963 -0.134840827
#  #> [17,]  0.007608049 -0.079445537 -0.013675459  0.102010778
#  #> [18,] -0.010343806  0.132392790 -0.151237533 -0.123955960
#  #> [19,]  0.252797503  0.253113165 -0.197620792  0.099319824
#  #> [20,] -0.044505498 -0.049962311  0.233024977  0.176211754
#  #> [21,]  0.084292730  0.366833682 -0.220176991 -0.035984666
#  #> [22,] -0.373913824 -0.060767726  0.036430343 -0.105248408
#  #> [23,]  0.316816197 -0.191114879 -0.127549606 -0.112775343
#  #> [24,]  0.008174405  0.158066938 -0.121000263  0.232613924
#  #> [25,] -0.388590727  0.098542973 -0.045207238  0.003838229
#  #> [26,] -0.109916673  0.042028223  0.031122592 -0.173521656
#  #> [27,] -0.040845604  0.023057708  0.067839093  0.084198705
#  #> [28,]  0.080696347 -0.097192796  0.099373268 -0.166716428
#  #> [29,] -0.117530646  0.002589360  0.051425084  0.098244052
#  #> [30,] -0.037935138 -0.091390269  0.154099931  0.100237663
#  #> [31,]  0.109674339  0.158620750 -0.181802621 -0.112714822
#  #> [32,]  0.069971569 -0.425139230 -0.020032195 -0.193571920
#  #> [33,]  0.050674415  0.050518682 -0.010950361 -0.068936556
#  #> [34,]  0.065490413  0.142178491  0.174034864  0.072663828
#  #> [35,] -0.045676268 -0.057128729  0.050522160 -0.165689753
#  #> [36,]  0.368217440  0.096573493  0.120128008  0.020252183
#  #> [37,]  0.037286542 -0.056101952 -0.018563948  0.263830281
#  #> [38,]  0.094379823 -0.263914331 -0.002747609 -0.010850423
#  #> [39,]  0.153890231  0.071449851 -0.075881371 -0.060456457
#  #> [40,] -0.146742186 -0.117294226 -0.255229801 -0.124537184
#  #> [41,] -0.274840831  0.009051742  0.124862149  0.074433697
#  #> [42,] -0.008508998  0.110465493  0.215727137  0.269240087
#  #> [43,]  0.014213371 -0.041499271  0.097848087  0.105722611
#  #> [44,] -0.080890432  0.094198355  0.004240823 -0.187634605
#  #> [45,]  0.051925330 -0.007981636  0.044460236 -0.066537564
#  #> [46,]  0.213031014  0.168676929  0.097190703  0.046563300
#  #> [47,]  0.175716867  0.045500673  0.175902385 -0.030590597
#  #> [48,] -0.040155598 -0.120432098 -0.137764051 -0.088812037
#  #> [49,]  0.164103981  0.024976184  0.015955563 -0.232780151
#  #> [50,] -0.103164763 -0.135032022  0.029553283  0.267389634
#  set.seed(1)
#  p_true <- 6
#  p <- 50
#  x <- mvtnorm::rmvnorm(480, rep(0, p), diag(p))
#  theta_0 <- rbind(
#    runif(p_true, -5, -2),
#    runif(p_true, -3, 3),
#    runif(p_true, 2, 5),
#    runif(p_true, -5, 5)
#  )
#  theta_0 <- cbind(theta_0, matrix(0, ncol = p - p_true, nrow = 4))
#  y <- c(
#    x[1:80, ] %*% theta_0[1, ] + rnorm(80, 0, 1),
#    x[81:200, ] %*% theta_0[2, ] + rnorm(120, 0, 1),
#    x[201:320, ] %*% theta_0[3, ] + rnorm(120, 0, 1),
#    x[321:480, ] %*% theta_0[4, ] + rnorm(160, 0, 1)
#  )
#  result_multiple_epochs <- fastcpd(
#    formula = y ~ . - 1,
#    data = data.frame(y = y, x = x),
#    family = "lasso",
#    multiple_epochs = function(segment_length) if (segment_length < 20) 1 else 0,
#    r.progress = FALSE
#  )
#  summary(result_multiple_epochs)
#  #>
#  #> Call:
#  #> fastcpd(formula = y ~ . - 1, data = data.frame(y = y, x = x),
#  #>     family = "lasso", multiple_epochs = function(segment_length) if (segment_length <
#  #>         20) 1 else 0, r.progress = FALSE)
#  #>
#  #> Change points:
#  #> 79 199 320
#  #>
#  #> Cost values:
#  #> 125.1501 155.4486 164.1284 177.9478
#  #>
#  #> Parameters:
#  #> 50 x 4 sparse Matrix of class "dgCMatrix"
#  #>          segment 1    segment 2    segment 3    segment 4
#  #>  [1,] -2.580352409 -2.428039439  4.898713954 -3.006202485
#  #>  [2,] -2.668688731 -2.473539196  4.209460633  3.096081968
#  #>  [3,] -4.354248176  0.983488542  5.011651466  3.718141515
#  #>  [4,] -4.662566697  0.279505605  2.623742216 -3.130632564
#  #>  [5,] -4.820139326  0.496565230  4.616444609  3.175562645
#  #>  [6,] -3.860308911 -2.576467859  3.336301862  4.342890940
#  #>  [7,]  0.117234534 -0.219145186 -0.039861426 -0.016395368
#  #>  [8,]  0.117552281  0.035701649 -0.075921029 -0.022022294
#  #>  [9,] -0.188756652  0.133653604  0.052907904  0.070683538
#  #> [10,] -0.074530965  0.010173561  0.003352400  0.012791767
#  #> [11,] -0.061721013 -0.176769170 -0.044814526 -0.166042077
#  #> [12,]  0.021874954 -0.133777712  0.103526247  0.077820866
#  #> [13,]  0.067777695  0.129187849 -0.072098209  0.077436979
#  #> [14,] -0.122270920  0.110865328  0.095306898  0.114046507
#  #> [15,] -0.014192027  0.086100909  0.006037145 -0.015966855
#  #> [16,] -0.135970691 -0.043211895  0.026749332 -0.095751983
#  #> [17,]  0.007608049 -0.079445537 -0.003130812 -0.010689927
#  #> [18,] -0.010343806  0.132392790 -0.156866781 -0.138057246
#  #> [19,]  0.252797503  0.253113165 -0.167436237  0.158967697
#  #> [20,] -0.044505498 -0.049962311  0.177560915  0.030169316
#  #> [21,]  0.084292730  0.366833682 -0.224849869 -0.181503446
#  #> [22,] -0.373913824 -0.060767726  0.003860114  0.045649997
#  #> [23,]  0.316816197 -0.191114879 -0.118941359 -0.025305755
#  #> [24,]  0.008174405  0.158066938 -0.135680402 -0.137396624
#  #> [25,] -0.388590727  0.098542973 -0.064383316  0.022336212
#  #> [26,] -0.109916673  0.042028223  0.017815134 -0.059782090
#  #> [27,] -0.040845604  0.023057708  0.053296378  0.030431412
#  #> [28,]  0.080696347 -0.097192796  0.122665492 -0.080706668
#  #> [29,] -0.117530646  0.002589360  0.062791240 -0.051542901
#  #> [30,] -0.037935138 -0.091390269  0.122976438  0.048892128
#  #> [31,]  0.109674339  0.158620750 -0.181785506  0.075434045
#  #> [32,]  0.069971569 -0.425139230  0.030472706  0.033375101
#  #> [33,]  0.050674415  0.050518682  0.034305534  0.070983107
#  #> [34,]  0.065490413  0.142178491  0.164899160  0.032575571
#  #> [35,] -0.045676268 -0.057128729  0.022794426 -0.134534869
#  #> [36,]  0.368217440  0.096573493  0.114099285 -0.020673038
#  #> [37,]  0.037286542 -0.056101952 -0.023029273  0.102043216
#  #> [38,]  0.094379823 -0.263914331  0.003288922 -0.052763017
#  #> [39,]  0.153890231  0.071449851 -0.097509620 -0.120642848
#  #> [40,] -0.146742186 -0.117294226 -0.208865036 -0.045775725
#  #> [41,] -0.274840831  0.009051742  0.127312770  0.123910218
#  #> [42,] -0.008508998  0.110465493  0.118453225 -0.005505113
#  #> [43,]  0.014213371 -0.041499271  0.113699538 -0.056131976
#  #> [44,] -0.080890432  0.094198355  0.051912519  0.013524984
#  #> [45,]  0.051925330 -0.007981636  0.085966205 -0.033628617
#  #> [46,]  0.213031014  0.168676929  0.035738422 -0.029655833
#  #> [47,]  0.175716867  0.045500673  0.175504506  0.119507574
#  #> [48,] -0.040155598 -0.120432098 -0.139162874 -0.054349982
#  #> [49,]  0.164103981  0.024976184  0.029374949 -0.056092814
#  #> [50,] -0.103164763 -0.135032022  0.047475507 -0.032491294
#  set.seed(1)
#  p_true <- 6
#  p <- 50
#  x <- mvtnorm::rmvnorm(480, rep(0, p), diag(p))
#  theta_0 <- rbind(
#    runif(p_true, -5, -2),
#    runif(p_true, -3, 3),
#    runif(p_true, 2, 5),
#    runif(p_true, -5, 5)
#  )
#  theta_0 <- cbind(theta_0, matrix(0, ncol = p - p_true, nrow = 4))
#  y <- c(
#    x[1:80, ] %*% theta_0[1, ] + rnorm(80, 0, 1),
#    x[81:200, ] %*% theta_0[2, ] + rnorm(120, 0, 1),
#    x[201:320, ] %*% theta_0[3, ] + rnorm(120, 0, 1),
#    x[321:480, ] %*% theta_0[4, ] + rnorm(160, 0, 1)
#  )
#  result_vanilla_percentage <- fastcpd(
#    formula = y ~ . - 1,
#    data = data.frame(y = y, x = x),
#    family = "lasso",
#    vanilla_percentage = 0.2,
#    r.progress = FALSE
#  )
#  summary(result_vanilla_percentage)
#  #>
#  #> Call:
#  #> fastcpd(formula = y ~ . - 1, data = data.frame(y = y, x = x),
#  #>     family = "lasso", vanilla_percentage = 0.2, r.progress = FALSE)
#  #>
#  #> Change points:
#  #> 79 199 317
#  #>
#  #> Cost values:
#  #> 125.1501 155.4486 160.4363 274.2228
#  #>
#  #> Parameters:
#  #> 50 x 4 sparse Matrix of class "dgCMatrix"
#  #>          segment 1    segment 2    segment 3    segment 4
#  #>  [1,] -2.580352409 -2.428039439  4.900559900 -2.749985232
#  #>  [2,] -2.668688731 -2.473539196  4.198921150  3.057387294
#  #>  [3,] -4.354248176  0.983488542  5.054325016  3.735347545
#  #>  [4,] -4.662566697  0.279505605  2.628354481 -3.216027015
#  #>  [5,] -4.820139326  0.496565230  4.611603593  3.231304715
#  #>  [6,] -3.860308911 -2.576467859  3.304903523  4.577405578
#  #>  [7,]  0.117234534 -0.219145186 -0.015091394 -0.086048806
#  #>  [8,]  0.117552281  0.035701649 -0.127986984 -0.138807479
#  #>  [9,] -0.188756652  0.133653604  0.038250526 -0.037807789
#  #> [10,] -0.074530965  0.010173561  0.021979969 -0.047707753
#  #> [11,] -0.061721013 -0.176769170 -0.059312332 -0.135633390
#  #> [12,]  0.021874954 -0.133777712  0.028889403 -0.130808437
#  #> [13,]  0.067777695  0.129187849 -0.026100120  0.002593292
#  #> [14,] -0.122270920  0.110865328  0.084858637  0.233903944
#  #> [15,] -0.014192027  0.086100909  0.030268607  0.243927135
#  #> [16,] -0.135970691 -0.043211895 -0.032229963 -0.134840827
#  #> [17,]  0.007608049 -0.079445537 -0.013675459  0.102010778
#  #> [18,] -0.010343806  0.132392790 -0.151237533 -0.123955960
#  #> [19,]  0.252797503  0.253113165 -0.197620792  0.099319824
#  #> [20,] -0.044505498 -0.049962311  0.233024977  0.176211754
#  #> [21,]  0.084292730  0.366833682 -0.220176991 -0.035984666
#  #> [22,] -0.373913824 -0.060767726  0.036430343 -0.105248408
#  #> [23,]  0.316816197 -0.191114879 -0.127549606 -0.112775343
#  #> [24,]  0.008174405  0.158066938 -0.121000263  0.232613924
#  #> [25,] -0.388590727  0.098542973 -0.045207238  0.003838229
#  #> [26,] -0.109916673  0.042028223  0.031122592 -0.173521656
#  #> [27,] -0.040845604  0.023057708  0.067839093  0.084198705
#  #> [28,]  0.080696347 -0.097192796  0.099373268 -0.166716428
#  #> [29,] -0.117530646  0.002589360  0.051425084  0.098244052
#  #> [30,] -0.037935138 -0.091390269  0.154099931  0.100237663
#  #> [31,]  0.109674339  0.158620750 -0.181802621 -0.112714822
#  #> [32,]  0.069971569 -0.425139230 -0.020032195 -0.193571920
#  #> [33,]  0.050674415  0.050518682 -0.010950361 -0.068936556
#  #> [34,]  0.065490413  0.142178491  0.174034864  0.072663828
#  #> [35,] -0.045676268 -0.057128729  0.050522160 -0.165689753
#  #> [36,]  0.368217440  0.096573493  0.120128008  0.020252183
#  #> [37,]  0.037286542 -0.056101952 -0.018563948  0.263830281
#  #> [38,]  0.094379823 -0.263914331 -0.002747609 -0.010850423
#  #> [39,]  0.153890231  0.071449851 -0.075881371 -0.060456457
#  #> [40,] -0.146742186 -0.117294226 -0.255229801 -0.124537184
#  #> [41,] -0.274840831  0.009051742  0.124862149  0.074433697
#  #> [42,] -0.008508998  0.110465493  0.215727137  0.269240087
#  #> [43,]  0.014213371 -0.041499271  0.097848087  0.105722611
#  #> [44,] -0.080890432  0.094198355  0.004240823 -0.187634605
#  #> [45,]  0.051925330 -0.007981636  0.044460236 -0.066537564
#  #> [46,]  0.213031014  0.168676929  0.097190703  0.046563300
#  #> [47,]  0.175716867  0.045500673  0.175902385 -0.030590597
#  #> [48,] -0.040155598 -0.120432098 -0.137764051 -0.088812037
#  #> [49,]  0.164103981  0.024976184  0.015955563 -0.232780151
#  #> [50,] -0.103164763 -0.135032022  0.029553283  0.267389634

