% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{components.fbl_prophet}
\alias{components.fbl_prophet}
\title{Extract meaningful components}
\usage{
\method{components}{fbl_prophet}(object, ...)
}
\arguments{
\item{object}{An estimated model.}

\item{...}{Unused.}
}
\value{
A \code{\link[fabletools:dable]{fabletools::dable()}} containing estimated states.
}
\description{
A prophet model consists of terms which are additively or multiplicatively
included in the model. Multiplicative terms are scaled proportionally to the
estimated trend, while additive terms are not.
}
\details{
Extracting a prophet model's components using this function allows you to
visualise the components in a similar way to \code{\link[prophet:prophet_plot_components]{prophet::prophet_plot_components()}}.
}
\examples{

\donttest{
if (requireNamespace("tsibbledata")) {
library(tsibble)
beer_components <- tsibbledata::aus_production \%>\%
  model(
    prophet = prophet(Beer ~ season("year", 4, type = "multiplicative"))
  ) \%>\%
  components()

beer_components

autoplot(beer_components)

library(ggplot2)
library(lubridate)
beer_components \%>\%
  ggplot(aes(x = quarter(Quarter), y = year, group = year(Quarter))) +
  geom_line()
}
}

}
