% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fre.R
\name{fre}
\alias{fre}
\title{Simple frequencies with support of labels, weights and multiple response variables.}
\usage{
fre(
  x,
  weight = NULL,
  drop_unused_labels = TRUE,
  prepend_var_lab = FALSE,
  stat_lab = getOption("expss.fre_stat_lab", c("Count", "Valid percent", "Percent",
    "Responses, \%", "Cumulative responses, \%"))
)
}
\arguments{
\item{x}{vector/data.frame/list. data.frames are considered as multiple
response variables. If \code{x} is list then vertically stacked frequencies
for each element of list will be generated,}

\item{weight}{numeric vector. Optional case weights. NA's and negative weights
treated as zero weights.}

\item{drop_unused_labels}{logical. Should we drop unused value labels?
Default is TRUE.}

\item{prepend_var_lab}{logical. Should we prepend variable label before value
labels? By default we will add variable labels to value labels only if
\code{x} or predictor is list (several variables).}

\item{stat_lab}{character. Labels for the frequency columns.}
}
\value{
object of class 'etable'. Basically it's a data.frame but class
  is needed for custom methods.
}
\description{
\code{fre} returns data.frame with six columns: labels or values, counts, 
valid percent (excluding NA), percent (with NA), percent of responses(for 
single-column \code{x} it equals to valid percent) and cumulative percent of 
responses.
}
\examples{
data(mtcars)
mtcars = mtcars \%>\% 
    apply_labels(
        mpg = "Miles/(US) gallon",
        cyl = "Number of cylinders",
        disp = "Displacement (cu.in.)",
        hp = "Gross horsepower",
        drat = "Rear axle ratio",
        wt = "Weight (lb/1000)",
        qsec = "1/4 mile time",
        vs = "Engine",
        vs = c("V-engine" = 0, 
                "Straight engine" = 1),
        am = "Transmission",
        am = c(automatic = 0, 
                manual=1),
        gear = "Number of forward gears",
        carb = "Number of carburetors"
    )

fre(mtcars$vs)

# stacked frequencies
fre(list(mtcars$vs, mtcars$am))

# multiple-choice variable
# brands - multiple response question
# Which brands do you use during last three months? 
set.seed(123)
brands = data.frame(t(replicate(20,sample(c(1:5,NA),4,replace = FALSE))))
# score - evaluation of tested product
score = sample(-1:1,20,replace = TRUE)
var_lab(brands) = "Used brands"
val_lab(brands) = make_labels("
                              1 Brand A
                              2 Brand B
                              3 Brand C
                              4 Brand D
                              5 Brand E
                              ")

var_lab(score) = "Evaluation of tested brand"
val_lab(score) = make_labels("
                             -1 Dislike it
                             0 So-so
                             1 Like it    
                             ")

fre(brands)

# stacked frequencies
fre(list(score, brands))

}
