% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bananas.R
\name{bananas}
\alias{bananas}
\title{Generation of "bananas" datasets}
\usage{
bananas(n, r = 5, s = 1)
}
\arguments{
\item{n}{Number of observations.}

\item{r}{Radius of the two half circles (default: 5).}

\item{s}{Standard deviation of noise (default 1).}
}
\value{
A list with two attributes:
 \describe{
  \item{x}{The (n,2) matrix of attributes.}
  \item{y}{The vector of class labels.}
 }
}
\description{
\code{bananas} generates a dataset with two classes separated by a nonlinear boundary.
}
\details{
This function generates a dataset with two complex-shaped classes, useful to test some nonlinear
or constrained clustering algorithms.
}
\examples{
data<-bananas(1000)
plot(data$x,pch=data$y,col=data$y)

}
\references{
F. Li, S. Li and T. Denoeux. k-CEVCLUS: Constrained evidential clustering of 
large dissimilarity data. Knowledge-Based Systems (142):29-44, 2018.
}
\seealso{
\code{\link{kcevclus}}
}
\author{
Feng Li.
}
