% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trunct.R
\name{e_trunct}
\alias{e_trunct}
\title{Compute moments of univariate truncated t distribution}
\usage{
e_trunct(a, b, df, r)
}
\arguments{
\item{a}{the left end of the truncation interval}

\item{b}{the right end of the truncation interval}

\item{df}{the degrees of freedom of the t distribution}

\item{r}{the degree of moment to compute}
}
\description{
Compute moments of univariate truncated t distribution
}
\details{
This function computes the r-th moment of the univariate t distribution on df degrees of freedom,
truncated to the interval (a,b). If parameters are vectors then the r[i]th moment is computed for each (a[i],b[i],v[i])
The methods are based on results in O'Hagan (1973) and work for df>r. Otherwise NaN is returned.
}
\examples{
 e_trunct(-3,3,3,2) # second moment of t distribution on 3df truncated to (-3,3)
 e_trunct(-2,2,4,1) # first moment, should be 0 by symmetry

 e_trunct(c(-3,-2),c(3,2),c(3,4),c(2,1)) # the function is vectorized


}
\references{
O'Hagan, A. (1973) Bayes estimation of a convex quadratic. \emph{Biometrika}  \strong{60} (3).
}

